/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.geo.local.common.enums;

import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public enum AdRank {
    TIER_FIRST_CITY(1, "\u4e00\u7ebf\u57ce\u5e02", Sets.newHashSet((Object[])new String[]{"11", "12", "2101", "31", "3201", "3205", "3202", "3301", "3302", "3702", "4101", "4201", "4301", "4419", "4401", "4403", "50", "5101", "6101"})),
    TIER_SECOND_CITY(2, "\u4e8c\u7ebf\u57ce\u5e02", Sets.newHashSet((Object[])new String[]{"1306", "1301", "1401", "2102", "2201", "2301", "3204", "3206", "3203", "3304", "3307", "3306", "3310", "3303", "3401", "3501", "3505", "3502", "3601", "3701", "3707", "3706", "4406", "4413", "4420", "4501", "5201", "5301", "6201", "6501"})),
    TIER_THIRD_CITY(3, "\u4e09\u7ebf\u57ce\u5e02", Sets.newHashSet((Object[])new String[]{"1309", "1304", "1310", "1303", "1302", "1305", "1502", "1501", "2103", "2202", "2306", "3208", "3207", "3212", "3213", "3209", "3210", "3211", "3305", "3403", "3411", "3412", "3407", "3402", "3509", "3503", "3506", "3607", "3604", "3611", "3609", "3717", "3708", "3713", "3710", "3703", "4103", "4113", "4114", "4107", "4115", "4110", "4117", "4211", "4210", "4206", "4205", "4307", "4304", "4303", "4306", "4302", "4451", "4407", "4452", "4405", "4408", "4412", "4404", "4503", "4502", "4601", "4602", "5106", "5107", "5203", "5303", "6104", "6301", "6401"})),
    CITY_OTHER(99, "\u5176\u4ed6", Sets.newHashSet());

    private Integer code;
    private String rankDesc;
    private Set<String> citySet;

    private AdRank(Integer code, String rankDesc, Set<String> citySet) {
        this.code = code;
        this.rankDesc = rankDesc;
        this.citySet = citySet;
    }

    public static AdRank getAdRankByCityName(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return CITY_OTHER;
        }
        AdRank[] adRanks = AdRank.values();
        for (int i = 0; i < adRanks.length; ++i) {
            AdRank adRank = adRanks[i];
            if (!adRank.citySet.stream().anyMatch(prefix -> code.startsWith((String)prefix))) continue;
            return adRank;
        }
        return CITY_OTHER;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getRankDesc() {
        return this.rankDesc;
    }

    public Set<String> getCitySet() {
        return this.citySet;
    }
}

