/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.geo.local.common.tire;

import cn.com.duiba.geo.local.common.tire.DefaultTireTreeNodePolicy;
import cn.com.duiba.geo.local.common.tire.TireTreeNode;
import cn.com.duiba.geo.local.common.tire.TireTreeNodePolicy;
import cn.com.duiba.geo.local.common.tire.TireTreeNodeShim;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class TireTree<T extends TireTreeNodeShim> {
    private final TireTreeNode root = new TireTreeNode();
    private int maxLevel = 0;
    private final TireTreeNodePolicy policy;

    public TireTree() {
        this.policy = new DefaultTireTreeNodePolicy();
    }

    public TireTree(TireTreeNodePolicy policy) {
        this.policy = policy;
    }

    public void insert(T node) {
        char[] chars;
        String code = node.getTireTreeKey();
        if (StringUtils.isBlank((CharSequence)code)) {
            throw new IllegalArgumentException("\u5b57\u5178\u6811\u7b56\u7565\u7684Code\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int size = this.policy.charSize();
        for (char item : chars = code.toCharArray()) {
            int index = this.policy.charIndex(item);
            if (index >= 0 && index < size) continue;
            throw new IllegalArgumentException("\u5b57\u5178\u6811\u7b56\u7565\u7684\u5b58\u5728\u503c\u57df\u6ea2\u51fa:" + code);
        }
        this.root.insert(chars, 0, this.policy, (TireTreeNodeShim)node);
        this.maxLevel = Math.max(this.maxLevel, chars.length);
    }

    public T find(String code) {
        char[] chars = code.toCharArray();
        TireTreeNode node = this.root.find(chars, 0, this.policy);
        if (Objects.isNull(node)) {
            return null;
        }
        return (T)node.getPayload();
    }

    public List<T> findNodeLink(String code) {
        char[] chars = code.toCharArray();
        LinkedList nodes = Lists.newLinkedList();
        this.root.findToList(chars, 0, nodes, this.policy);
        return this.transform(nodes);
    }

    public List<T> findChildNodes(String parentCode, Boolean acceptParentNotExist) {
        TireTreeNode node;
        char[] chars = new char[]{};
        if (StringUtils.isNotBlank((CharSequence)parentCode)) {
            chars = parentCode.toCharArray();
        }
        if (Objects.isNull(node = this.root.find(chars, 0, this.policy))) {
            return Collections.emptyList();
        }
        if (Objects.isNull(node.getPayload()) && !acceptParentNotExist.booleanValue()) {
            return Collections.emptyList();
        }
        LinkedList keys = Lists.newLinkedList();
        node.findInDeep(keys);
        return this.transform(keys);
    }

    private List<T> transform(List<TireTreeNode> keys) {
        LinkedList returnList = Lists.newLinkedList();
        for (TireTreeNode node : keys) {
            TireTreeNodeShim shim = node.getPayload();
            if (!Objects.nonNull(shim)) continue;
            returnList.add(shim);
        }
        return returnList;
    }

    public boolean isEmpty() {
        return this.maxLevel == 0;
    }
}

