/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.geo.local.dao;

import cn.com.duiba.geo.local.domain.entity.GeoPointDO;
import cn.com.duiba.geo.local.tool.CsvUtils;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Repository;

@Repository
public class GeoPointDao {
    DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private List<GeoPointDO> list = new LinkedList<GeoPointDO>();

    @PostConstruct
    public void init() {
        String[] header = new String[]{"id", "gmt_create", "gmt_modified", "ad_code", "geo_hash", "latitude", "longitude", "master"};
        List<String[]> read = CsvUtils.read(header, "tb_geo_point.csv");
        read.forEach(e -> this.list.add(this.transfer((String[])e)));
    }

    public List<GeoPointDO> findAll() {
        return this.list;
    }

    public GeoPointDO transfer(String[] data) {
        GeoPointDO pointDO = new GeoPointDO();
        pointDO.setId(Long.valueOf(data[0]));
        pointDO.setAdCode(data[3]);
        pointDO.setGeoHash(data[4]);
        pointDO.setLatitude(Double.valueOf(data[5]));
        pointDO.setLongitude(Double.valueOf(data[6]));
        pointDO.setMaster(data[7].equals("1"));
        pointDO.setGmtCreate(Date.from(LocalDateTime.parse(data[1], this.formatter).atZone(ZoneId.systemDefault()).toInstant()));
        pointDO.setGmtModified(Date.from(LocalDateTime.parse(data[2], this.formatter).atZone(ZoneId.systemDefault()).toInstant()));
        return pointDO;
    }
}

