/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.geo.local.remote;

import ch.hsr.geohash.GeoHash;
import ch.hsr.geohash.WGS84Point;
import cn.com.duiba.geo.local.dto.CoordinateSystem;
import cn.com.duiba.geo.local.dto.GeoInfoDto;
import cn.com.duiba.geo.local.dto.Point;
import cn.com.duiba.geo.local.service.point.GeoPointService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RemoteGeoLocalService {
    private static final Logger log = LoggerFactory.getLogger(RemoteGeoLocalService.class);
    @Resource
    private GeoPointService geoPointService;

    public GeoInfoDto findGeoInfoByGeoHash(String geoHash, CoordinateSystem coordinateSystem) {
        if (geoHash.length() > 8) {
            geoHash = geoHash.substring(0, 8);
        }
        GeoHash sourceGeoHash = GeoHash.fromGeohashString((String)geoHash);
        if (coordinateSystem == CoordinateSystem.GCJ02 || coordinateSystem == null) {
            return this.geoPointService.findGeoInfoDto(sourceGeoHash);
        }
        WGS84Point point = sourceGeoHash.getOriginatingPoint();
        GeoHash gcj02Hash = this.geoPointService.transformGeoHash(point, coordinateSystem);
        return this.geoPointService.findGeoInfoDto(gcj02Hash);
    }

    public GeoInfoDto findGeoInfoByPoint(Point point, CoordinateSystem coordinateSystem) {
        WGS84Point params = new WGS84Point(point.getLatitude(), point.getLongitude());
        GeoHash gcj02Hash = this.geoPointService.transformGeoHash(params, coordinateSystem);
        return this.geoPointService.findGeoInfoDto(gcj02Hash);
    }
}

