/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.geo.local.service.ad;

import cn.com.duiba.geo.local.common.tire.TireTree;
import cn.com.duiba.geo.local.dao.AdministrativeDivisionDao;
import cn.com.duiba.geo.local.domain.entity.AdministrativeDivisionDO;
import cn.com.duiba.geo.local.dto.AdministrativeDivisionDto;
import cn.com.duiba.geo.local.service.ad.AdministrativeDivisionTreeNode;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Order(value=0x7FFFFFFE)
public class AdministrativeDivisionService {
    private static final Logger log = LoggerFactory.getLogger(AdministrativeDivisionService.class);
    @Resource
    private AdministrativeDivisionDao administrativeDivisionDao;
    private volatile TireTree<AdministrativeDivisionTreeNode> tireTree = new TireTree();
    private volatile Multimap<String, AdministrativeDivisionTreeNode> areaNameMap = HashMultimap.create();

    @PostConstruct
    public void initData() {
        TireTree<AdministrativeDivisionTreeNode> newTireTree = new TireTree<AdministrativeDivisionTreeNode>();
        HashMultimap newAreaNameMap = HashMultimap.create();
        List<AdministrativeDivisionDO> list = this.administrativeDivisionDao.findSimpleAll();
        for (AdministrativeDivisionDO item : list) {
            AdministrativeDivisionTreeNode node = new AdministrativeDivisionTreeNode();
            node.setCode(item.getCode());
            node.setName(item.getName());
            node.setLevel(item.getLevel());
            newAreaNameMap.put((Object)item.getName(), (Object)node);
            newAreaNameMap.put((Object)this.simpleName(item.getName()), (Object)node);
            newTireTree.insert(node);
        }
        this.tireTree = newTireTree;
        this.areaNameMap = newAreaNameMap;
        log.info("\u884c\u653f\u533a\u5212\u5b57\u5178\u6811\u6784\u5efa\u5b8c\u6210,\u603b\u6570:" + list.size());
    }

    public List<AdministrativeDivisionDto> findCodeLink(String code) {
        if (!this.isLegal(code).booleanValue()) {
            return Collections.emptyList();
        }
        String key = AdministrativeDivisionTreeNode.analysisCode(code);
        List<AdministrativeDivisionTreeNode> list = this.tireTree.findNodeLink(key);
        return this.trasform(list);
    }

    private List<AdministrativeDivisionDto> trasform(List<AdministrativeDivisionTreeNode> nodes) {
        ArrayList returnList = Lists.newArrayList();
        for (AdministrativeDivisionTreeNode node : nodes) {
            AdministrativeDivisionDto dto = new AdministrativeDivisionDto();
            dto.setAdCode(node.getCode());
            dto.setName(node.getName());
            dto.setLevel(node.getLevel());
            returnList.add(dto);
        }
        return returnList;
    }

    public String simpleName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return name;
        }
        if (name.length() <= 2) {
            return name;
        }
        if (name.contains("\u81ea\u6cbb")) {
            return name;
        }
        if (StringUtils.endsWithAny((CharSequence)name, (CharSequence[])new CharSequence[]{"\u7701", "\u5dde", "\u5e02", "\u53bf", "\u9547"})) {
            return name.substring(0, name.length() - 1);
        }
        if (StringUtils.endsWith((CharSequence)name, (CharSequence)"\u8857\u9053")) {
            return name.substring(0, name.length() - 2);
        }
        return name;
    }

    public Boolean isLegal(String adcode) {
        if (StringUtils.equals((CharSequence)"", (CharSequence)adcode)) {
            return true;
        }
        int length = adcode.length();
        if (length != 6 && length != 9 && length != 12) {
            return false;
        }
        try {
            Integer.parseInt(adcode);
        }
        catch (NumberFormatException e) {
            log.debug(adcode + "\u53c2\u6570\u4e0d\u5408\u6cd5");
            return false;
        }
        return true;
    }
}

