/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.geo.local.service.ad;

import cn.com.duiba.geo.local.common.tire.TireTreeNodeShim;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class AdministrativeDivisionTreeNode
implements TireTreeNodeShim {
    private static final LinkedHashMap<Integer, Integer> CODE_LENGTH_FOR_LEVEL = Maps.newLinkedHashMap();
    private static final Pattern PATTERN;
    private String code;
    private String name;
    private int level;

    @Override
    public String getTireTreeKey() {
        if (StringUtils.isBlank((CharSequence)this.code)) {
            return "";
        }
        return AdministrativeDivisionTreeNode.analysisCode(this.code, this.level);
    }

    public static String analysisCode(String code) {
        int level = AdministrativeDivisionTreeNode.analysisLevelByCode(code);
        return AdministrativeDivisionTreeNode.analysisCode(code, level);
    }

    private static String analysisCode(String code, int level) {
        String fullCode = AdministrativeDivisionTreeNode.buildFullAdCode(code);
        int end = CODE_LENGTH_FOR_LEVEL.getOrDefault(level, 0);
        return fullCode.substring(0, end);
    }

    public static int analysisLevelByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return 0;
        }
        String fullCode = AdministrativeDivisionTreeNode.buildFullAdCode(code);
        LinkedList codeList = Lists.newLinkedList();
        for (int level : CODE_LENGTH_FOR_LEVEL.keySet()) {
            int start = CODE_LENGTH_FOR_LEVEL.getOrDefault(level - 1, 0);
            int end = CODE_LENGTH_FOR_LEVEL.getOrDefault(level, 0);
            codeList.add(fullCode.substring(start, end));
        }
        int level = 0;
        int index = 0;
        for (String item : codeList) {
            ++index;
            if (PATTERN.matcher(item).find()) continue;
            level = index;
        }
        return level;
    }

    private static String buildFullAdCode(String code) {
        StringBuilder builder = new StringBuilder(code);
        int def = 12 - code.length();
        for (int i = 0; i < def; ++i) {
            builder.append(0);
        }
        return builder.toString();
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public int getLevel() {
        return this.level;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdministrativeDivisionTreeNode)) {
            return false;
        }
        AdministrativeDivisionTreeNode other = (AdministrativeDivisionTreeNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        return this.getLevel() == other.getLevel();
    }

    protected boolean canEqual(Object other) {
        return other instanceof AdministrativeDivisionTreeNode;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        result = result * 59 + this.getLevel();
        return result;
    }

    public String toString() {
        return "AdministrativeDivisionTreeNode(code=" + this.getCode() + ", name=" + this.getName() + ", level=" + this.getLevel() + ")";
    }

    static {
        CODE_LENGTH_FOR_LEVEL.put(1, 2);
        CODE_LENGTH_FOR_LEVEL.put(2, 4);
        CODE_LENGTH_FOR_LEVEL.put(3, 6);
        CODE_LENGTH_FOR_LEVEL.put(4, 9);
        CODE_LENGTH_FOR_LEVEL.put(5, 12);
        PATTERN = Pattern.compile("^0*$");
    }
}

