/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.geo.local.tool;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CsvUtils {
    private static final Logger log = LoggerFactory.getLogger(CsvUtils.class);

    public static List<String[]> read(String[] header, String filePath) {
        LinkedList<String[]> result = new LinkedList<String[]>();
        try {
            InputStreamReader in = new InputStreamReader(CsvUtils.class.getResourceAsStream("/" + filePath));
            CSVFormat build = CSVFormat.Builder.create().setHeader(header).setSkipHeaderRecord(true).build();
            CSVParser parse = build.parse((Reader)in);
            List records = parse.getRecords();
            for (int i = 0; i < records.size(); ++i) {
                CSVRecord record = (CSVRecord)records.get(i);
                String[] re = new String[header.length];
                for (int j = 0; j < header.length; ++j) {
                    re[j] = record.get(j);
                }
                result.add(re);
            }
        }
        catch (IOException e) {
            log.error("read geo file error, ", (Throwable)e);
        }
        return result;
    }
}

