package cn.com.duiba.goods.center.api.remoteservice.jbp;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * JBP供应商远程服务接口
 * 
 * @author zhangdaqing
 * @Description JBP供应商服务接口
 * @date 2025/11/17 11:17
 */
@AdvancedFeignClient
public interface RemoteJbpSupplierService {


    /**
     * 计算商品ItemId的累计发放数量，并返回是第几个发放的
     * 使用Lua脚本保证原子性操作
     * 
     * @param itemId 商品ID
     * @param maxLimit 上限值，如果为null或小于等于0则不限制
     * @return 第几个发放的（累计发放数量），如果超过上限则返回-1
     */
    int calculateAndGetIssueSequence(Long itemId, Integer maxLimit);

    /**
     * 重置商品ItemId的累计发放数量
     * 将累计发放数量重置为0
     * 
     * @param itemId 商品ID
     * @return 是否重置成功
     */
    boolean resetIssueSequence(Long itemId);



    /**
     * 设置商品编码
     * 
     * @param itemId 商品ID
     * @param productCode 商品编码
     * @param seconds 过期时间（秒），如果小于等于0则不过期
     * @return 是否设置成功
     */
    boolean setProductCode(Long itemId, String productCode, int seconds);

    /**
     * 查询商品编码
     * 
     * @param itemId 商品ID
     * @return 商品编码，如果不存在或异常则返回null
     */
    String getProductCode(Long itemId);
}
