package cn.com.duiba.goods.center.api.remoteservice.param;

import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang.StringUtils;

import java.io.Serializable;

/**
 * Created by hww on 2018/4/24 下午5:24.
 */
public class CollectGoodsPrizeLimitParam implements Serializable {

    private static final long serialVersionUID = -1L;

    /** 集卡商品中奖限制作用域 */
    private String scope;
    /** 集卡商品中奖限制次数 */
    private Integer count;

    public static String encode(CollectGoodsPrizeLimitParam param) {
        return param == null ? null : JSONObject.toJSONString(param);
    }

    public static CollectGoodsPrizeLimitParam decode(String param) {
        return StringUtils.isBlank(param) ? null : JSONObject.parseObject(param, CollectGoodsPrizeLimitParam.class);
    }

    public CollectGoodsPrizeLimitParam() {

    }

    public CollectGoodsPrizeLimitParam(String scope, Integer count) {
        this.scope = scope;
        this.count = count;
    }

    public String getScope() {
        return scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public Integer getCount() {
        return count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }
}
