package cn.com.duiba.goods.center.api.remoteservice.util;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDto;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;

/**
 * @author zhengjianhao
 * @date 18/10/19
 * @description
 */
public class ItemCommUtils {

	/**
	 * 是否是直充类商品
	 */
	public static boolean isDegree(String itemType){
		if(ItemDto.TypePhonebill.equals(itemType)){
			return true;
		}
		if(ItemDto.TypeQB.equals(itemType)){
			return true;
		}
		if(ItemDto.TypeAlipay.equals(itemType)){
			return true;
		}
		if(ItemDto.TypeAlipayFast.equals(itemType)){
			return true;
		}
		if(ItemDto.TypeAlipayCode.equals(itemType)){
			return true;
		}
		return false;
	}

	/**
	 * 服务费率转换
	 * @param rate
	 * @return
	 */
	public static BigDecimal getRealRate(Integer rate){
		return new BigDecimal(rate).divide(new BigDecimal(10000));
	}

	/**
	 * 服务费率显示
	 * @param rate
	 * @return
	 */
	public static String getShowRate(Integer rate) {
		BigDecimal divide = new BigDecimal(rate).divide(new BigDecimal(100)).setScale(2,BigDecimal.ROUND_HALF_UP);;
		return divide.toString();
	}

    public static Integer grantOpTypeItem(Integer operationsType, int opType) {
        int v = 1 << opType;
        return operationsType | v;
    }

    /**
     * ungrantOpTypeItem
     * @param opType
     */
    public static Integer ungrantOpTypeItem(Integer operationsType, int opType) {
        int v = 1 << opType;
        v = ~v;
        return operationsType & v;
    }

    /**
     * ungrantOpTypeItem
     * @param opType
     * @return
     */
    public static boolean isOpTypeItem(Integer operationsType, int opType) {
        int v = 1 << opType;
        int ret = operationsType & v;
        return ret != 0;
    }
}
