package cn.com.duiba.goods.center.api.remoteservice.enums;

/**
 * Created by xiaoxuda on 2018/8/1.
 */
public enum GoodsAttrType {
    SKU(1, "销售属性"),
    SEARCH(2, "查询属性");

    private Integer code;
    private String desc;

    GoodsAttrType(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public static GoodsAttrType getByCode(Integer code){
        for(GoodsAttrType type : values()){
            if(type.getCode().equals(code)){
                return type;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
