package cn.com.duiba.goods.center.api.remoteservice.enums;

public enum CardLibraryTypeEnum {
    //用于发放
    NORMAL(0, "普通卡券"),
    //用于存储
    STORE(1, "总卡券库"),
    ;

    private int type;

    private String desc;

    CardLibraryTypeEnum(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    /**
     * 根据类型，反查枚举类<br/>
     * 若是没找到，返回null
     *
     * @param type 枚举类型
     * @return 枚举类
     */
    public static CardLibraryTypeEnum getCardLibraryTypeEnum(Integer type) {
        if(type == null){
            return null;
        }
        CardLibraryTypeEnum[] values = CardLibraryTypeEnum.values();
        for (CardLibraryTypeEnum value : values) {
            if (value.getType() == type) {
                return value;
            }
        }

        return null;
    }
}
