/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.api.remoteservice.dto.item;

import java.io.Serializable;

public class ItemQueries
implements Serializable {
    private static final long serialVersionUID = -47787140896534918L;
    private static final int OFFSET_DESC = 1;
    private static final int OFFSET_LIMIT = 2;
    private static final int OFFSET_SKU = 4;
    private static final int OFFSET_CREDITS = 8;
    private static final int OFFSET_CREDITS_SKU = 16;
    private static final int OFFSET_SUPPLY_PRICE = 32;
    private int value;
    private boolean queryCache;

    public ItemQueries() {
    }

    private ItemQueries(boolean all, boolean queryCache) {
        if (all) {
            this.value = Integer.MAX_VALUE;
        }
        this.queryCache = queryCache;
    }

    public static ItemQueries empty() {
        return new ItemQueries();
    }

    public static ItemQueries all() {
        return new ItemQueries(true, false);
    }

    public boolean isEmpty() {
        return this.value == 0;
    }

    public ItemQueries queryFromCache() {
        this.queryCache = true;
        return this;
    }

    public ItemQueries queryWithoutCace() {
        this.queryCache = false;
        return this;
    }

    public ItemQueries withDescConfig() {
        return this.with(1);
    }

    public ItemQueries withLimitConfig() {
        return this.with(2);
    }

    public ItemQueries withSku() {
        return this.with(4);
    }

    public ItemQueries withCredits() {
        return this.with(8);
    }

    public ItemQueries withCreditsSku() {
        return this.with(16);
    }

    public ItemQueries withSupplyPrice() {
        return this.with(32);
    }

    private ItemQueries with(int offset) {
        this.value |= offset;
        return this;
    }

    public ItemQueries withoutDescConfig() {
        return this.without(1);
    }

    public ItemQueries withoutLimitConfig() {
        return this.without(2);
    }

    public ItemQueries withoutSku() {
        return this.without(4);
    }

    public ItemQueries withoutCredits() {
        return this.without(8);
    }

    public ItemQueries withoutCreditsSku() {
        return this.without(16);
    }

    public ItemQueries withoutSupplyPrice() {
        return this.without(32);
    }

    private ItemQueries without(int offset) {
        this.value &= ~offset;
        return this;
    }

    public boolean hasDescConfig() {
        return this.has(1);
    }

    public boolean hasLimitConfig() {
        return this.has(2);
    }

    public boolean hasSku() {
        return this.has(4);
    }

    public boolean hasCredits() {
        return this.has(8);
    }

    public boolean hasCreditsSku() {
        return this.has(16);
    }

    public boolean hasSupplyPrice() {
        return this.has(32);
    }

    private boolean has(int offset) {
        return (this.value & offset) > 0;
    }

    public boolean isQueryFromCache() {
        return this.queryCache;
    }
}

