package cn.com.duiba.goods.center.api.remoteservice.param;

import java.io.Serializable;
import java.util.List;

/**
 * <p>商品详情描述查询参数</p>
 * <p>created by Xuwei on 2021/2/22<p>
 **/
public class ItemDescConfigQueries implements Serializable {

    private static final long serialVersionUID = 1630874977042169239L;

    /**
     * 配置id
     */
    public static final int RELATION_TYPE_CONFIG_ID = 0;
    /**
     * 开发者商品id
     */
    public static final int RELATION_TYPE_APP_ITEM_ID = 1;
    /**
     * 兑吧商品ID
     */
    public static final int RELATION_TYPE_ITEM_ID = 2;

    /**
     * 关联id列表
     */
    private List<Long> relationIds;
    /**
     * 关联id类型，可能取值为 配置id, 开发者商品id，兑吧商品id
     * @see #RELATION_TYPE_CONFIG_ID
     * @see #RELATION_TYPE_APP_ITEM_ID
     * @see #RELATION_TYPE_ITEM_ID
     */
    private int relationType = RELATION_TYPE_CONFIG_ID;

    /**
     * 是否包含详情
     */
    private boolean includeDescription;

    /**
     * 是否包含详情图
     */
    private boolean includeMultiImage;
    /**
     * 是否包含待发货文案
     */
    private boolean includeAlertMessage;
    /**
     * 是否包含待发货时间文案
     */
    private boolean includeDeliveryTimeMessage;
    /**
     * 是否包含卖点描述
     */
    private boolean includeSellingPoint;
    /**
     * 是否包含微信分享文案
     */
    private boolean includeWeixinShareDesc;
    /**
     * 是否包含使用规则
     */
    private boolean includeUsageRule;


    public List<Long> getRelationIds() {
        return relationIds;
    }

    public void setRelationIds(List<Long> relationIds) {
        this.relationIds = relationIds;
    }

    public int getRelationType() {
        return relationType;
    }

    public void setRelationType(int relationType) {
        this.relationType = relationType;
    }

    public boolean isIncludeDescription() {
        return includeDescription;
    }

    public void setIncludeDescription(boolean includeDescription) {
        this.includeDescription = includeDescription;
    }

    public boolean isIncludeMultiImage() {
        return includeMultiImage;
    }

    public void setIncludeMultiImage(boolean includeMultiImage) {
        this.includeMultiImage = includeMultiImage;
    }

    public boolean isIncludeAlertMessage() {
        return includeAlertMessage;
    }

    public void setIncludeAlertMessage(boolean includeAlertMessage) {
        this.includeAlertMessage = includeAlertMessage;
    }

    public boolean isIncludeDeliveryTimeMessage() {
        return includeDeliveryTimeMessage;
    }

    public void setIncludeDeliveryTimeMessage(boolean includeDeliveryTimeMessage) {
        this.includeDeliveryTimeMessage = includeDeliveryTimeMessage;
    }

    public boolean isIncludeSellingPoint() {
        return includeSellingPoint;
    }

    public void setIncludeSellingPoint(boolean includeSellingPoint) {
        this.includeSellingPoint = includeSellingPoint;
    }

    public boolean isIncludeWeixinShareDesc() {
        return includeWeixinShareDesc;
    }

    public void setIncludeWeixinShareDesc(boolean includeWeixinShareDesc) {
        this.includeWeixinShareDesc = includeWeixinShareDesc;
    }

    public boolean isIncludeUsageRule() {
        return includeUsageRule;
    }

    public void setIncludeUsageRule(boolean includeUsageRule) {
        this.includeUsageRule = includeUsageRule;
    }
}
