package cn.com.duiba.goods.center.api.remoteservice.dto;

import cn.com.duiba.goods.center.api.remoteservice.enums.VersionPlanEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 旺店通供应商API配置DTO
 * 
 * @author cgq
 * @date 2024-12-19
 */
public class WdtSupplierApiConfigDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 供应商ID
     */
    private Long supplierId;

    /**
     * 版本套餐：1-企业版，2-旗舰版
     * @see VersionPlanEnum
     */
    private Integer versionPlan;

    /**
     * 卖家账号
     */
    private String sellerAccount;

    /**
     * 接口账号
     */
    private String apiAccount;

    /**
     * appsecret
     */
    private String appSecret;

    /**
     * 盐值（旗舰版使用）
     */
    private String salt;

    /**
     * 店铺编号
     */
    private String shopNo;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public Integer getVersionPlan() {
        return versionPlan;
    }

    public void setVersionPlan(Integer versionPlan) {
        this.versionPlan = versionPlan;
    }

    public String getSellerAccount() {
        return sellerAccount;
    }

    public void setSellerAccount(String sellerAccount) {
        this.sellerAccount = sellerAccount;
    }

    public String getApiAccount() {
        return apiAccount;
    }

    public void setApiAccount(String apiAccount) {
        this.apiAccount = apiAccount;
    }

    public String getAppSecret() {
        return appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public String getSalt() {
        return salt;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    public String getShopNo() {
        return shopNo;
    }

    public void setShopNo(String shopNo) {
        this.shopNo = shopNo;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}
