package cn.com.duiba.goods.center.api.remoteservice.enums;

import lombok.Getter;

/**
 * 旺店通版本套餐枚举
 * 
 * @author cgq
 * @date 2024-12-19
 */
@Getter
public enum VersionPlanEnum {
    ENTERPRISE(1, "企业版"),
    FLAGSHIP(2, "旗舰版");

    private final int value;
    private final String desc;

    VersionPlanEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static VersionPlanEnum fromValue(int value) {
        for (VersionPlanEnum it : VersionPlanEnum.values()) {
            if (value == it.getValue()) {
                return it;
            }
        }
        return null;
    }
}
