/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.api.remoteservice.util;

import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duiba.goods.center.api.remoteservice.enums.VersionPlanEnum;
import org.apache.commons.lang3.StringUtils;

public class WdtUrlUtil {
    private static final String ENTERPRISE_PUSH_URL_TEST = "https://sandbox.wangdian.cn/openapi2/trade_push.php";
    private static final String ENTERPRISE_PUSH_URL_PROD = "https://api.wangdian.cn/openapi2/trade_push.php";
    private static final String ENTERPRISE_LOGISTICS_QUERY_URL_TEST = "https://sandbox.wangdian.cn/openapi2/logistics_sync_query.php";
    private static final String ENTERPRISE_LOGISTICS_QUERY_URL_PROD = "https://api.wangdian.cn/openapi2/logistics_sync_query.php";
    private static final String FLAGSHIP_BASE_URL_TEST = "http://47.92.239.46/openapi";
    private static final String FLAGSHIP_BASE_URL_PROD = "http://wdt.wangdian.cn/openapi";
    private static final String FLAGSHIP_PUSH_INTERFACE = "sales.RawTrade.pushSelf";
    private static final String FLAGSHIP_LOGISTICS_QUERY_INTERFACE = "sales.LogisticsSync.getSyncListExt";

    private static boolean isTestEnv() {
        return SpringEnvironmentUtils.isTestEnv();
    }

    public static String getPushUrl(VersionPlanEnum versionPlan) {
        if (versionPlan == null) {
            return null;
        }
        boolean isTest = WdtUrlUtil.isTestEnv();
        switch (versionPlan) {
            case ENTERPRISE: {
                return isTest ? ENTERPRISE_PUSH_URL_TEST : ENTERPRISE_PUSH_URL_PROD;
            }
            case FLAGSHIP: {
                String baseUrl = isTest ? FLAGSHIP_BASE_URL_TEST : FLAGSHIP_BASE_URL_PROD;
                return baseUrl + "/" + FLAGSHIP_PUSH_INTERFACE;
            }
        }
        return null;
    }

    public static String getPushUrl(Integer versionPlanValue) {
        if (versionPlanValue == null) {
            return null;
        }
        VersionPlanEnum versionPlan = VersionPlanEnum.fromValue(versionPlanValue);
        return WdtUrlUtil.getPushUrl(versionPlan);
    }

    public static String getLogisticsQueryUrl(VersionPlanEnum versionPlan) {
        if (versionPlan == null) {
            return null;
        }
        boolean isTest = WdtUrlUtil.isTestEnv();
        switch (versionPlan) {
            case ENTERPRISE: {
                return isTest ? ENTERPRISE_LOGISTICS_QUERY_URL_TEST : ENTERPRISE_LOGISTICS_QUERY_URL_PROD;
            }
            case FLAGSHIP: {
                String baseUrl = isTest ? FLAGSHIP_BASE_URL_TEST : FLAGSHIP_BASE_URL_PROD;
                return baseUrl + "/" + FLAGSHIP_LOGISTICS_QUERY_INTERFACE;
            }
        }
        return null;
    }

    public static String getLogisticsQueryUrl(Integer versionPlanValue) {
        if (versionPlanValue == null) {
            return null;
        }
        VersionPlanEnum versionPlan = VersionPlanEnum.fromValue(versionPlanValue);
        return WdtUrlUtil.getLogisticsQueryUrl(versionPlan);
    }

    public static String getUrl(String urlType, VersionPlanEnum versionPlan) {
        if (StringUtils.isBlank((CharSequence)urlType) || versionPlan == null) {
            return null;
        }
        switch (urlType.toLowerCase()) {
            case "push": {
                return WdtUrlUtil.getPushUrl(versionPlan);
            }
            case "logistics": 
            case "logistics_query": {
                return WdtUrlUtil.getLogisticsQueryUrl(versionPlan);
            }
        }
        return null;
    }

    public static String getUrl(String urlType, Integer versionPlanValue) {
        if (StringUtils.isBlank((CharSequence)urlType) || versionPlanValue == null) {
            return null;
        }
        VersionPlanEnum versionPlan = VersionPlanEnum.fromValue(versionPlanValue);
        return WdtUrlUtil.getUrl(urlType, versionPlan);
    }

    public static String getFlagshipBaseUrl() {
        boolean isTest = WdtUrlUtil.isTestEnv();
        return isTest ? FLAGSHIP_BASE_URL_TEST : FLAGSHIP_BASE_URL_PROD;
    }

    public static String getFlagshipPushInterface() {
        return FLAGSHIP_PUSH_INTERFACE;
    }

    public static String getFlagshipLogisticsQueryInterface() {
        return FLAGSHIP_LOGISTICS_QUERY_INTERFACE;
    }
}

