/**
 * Project Name:goods-center-biz
 * File Name:RedisCouponTakeWorker.java
 * Package Name:cn.com.duiba.goods.center.biz.bo.impl
 * Date:2016年5月25日下午12:04:24
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.bo.impl;

import java.util.concurrent.TimeUnit;

import org.springframework.data.redis.core.RedisTemplate;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.biz.entity.GoodsCouponEntity;

/**
 * ClassName:RedisCouponTakeWorker <br/>
 * Function: 结合redis，发券性能优化服务 <br/>
 * Date:     2016年5月25日 下午12:04:24 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public class RedisCouponTakeWorker {

    RedisTemplate<String, String> redisTemplate;
    
    private RedisTemplate<String, GoodsCouponEntity> redisTemplateCoupons;
    /**
     * 尝试分布式锁
     * @author xuhengfei
     * @param goodsBatchId
     * @return
     * @since JDK 1.6
     */
    private boolean tryLockBatch(Long goodsBatchId){
        Long value=redisTemplate.opsForValue().increment(getBatchLockKey(goodsBatchId), 1);
        if(value==1){
            redisTemplate.expire(getBatchLockKey(goodsBatchId), 30, TimeUnit.SECONDS);
            return true;
        }else{
            return false;
        }
    }
    
    private void unlockBatch(Long goodsBatchId){
        redisTemplate.delete(getBatchLockKey(goodsBatchId));
    }
    
    private String getBatchLockKey(Long goodsBatchId){
        return "xxx-"  + goodsBatchId;
    }
    
    private String getBatchContentKey(Long goodsBatchId){
        return "xxxxxx-"+goodsBatchId;
    }
    
    
    public GoodsCouponEntity takeOneCouponInBatch(GoodsTypeEnum gtype, long gid, long consumerId,long goodsBatchId) throws Exception{
        //redis队列查询
        redisTemplateCoupons.opsForSet().size(getBatchContentKey(goodsBatchId));
        GoodsCouponEntity entity=redisTemplateCoupons.opsForSet().pop(getBatchContentKey(goodsBatchId));
        
        
        //如果为空，获取分布式锁，捞数据
        
        
        //如果抛异常，通过数据库取数据
        
        //如果正常，从redis取数据
        
        
        
        
        return null;
    }
    
}

