/**
 * Project Name:goods-center-biz
 * File Name:GoodsCouponDao.java
 * Package Name:cn.com.duiba.goods.center.biz.dao
 * Date:2016年5月23日下午12:13:32
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.dao;

import java.util.List;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.biz.entity.GoodsCouponEntity;

/**
 * ClassName:GoodsCouponDao <br/>
 * Date:     2016年5月23日 下午12:13:32 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface GoodsCouponDao {
    /**
     * 
     * insertBatchImport:批量导入普通优惠劵. <br/>
     *
     * @author xuhengfei
     * @param gtype
     * @param gid
     * @param goodsBatchId
     * @param coupons
     * @since JDK 1.6
     */
    int insertBatchImport(GoodsTypeEnum gtype,long gid,long goodsBatchId,List<CouponFormat> coupons );
    /**
     * 
     * insertLinkCoupon:导入一条链接券. <br/>
     *
     * @author xuhengfei
     * @param gtype
     * @param gid
     * @param goodsBatchId
     * @param goodsCouponId
     * @param link
     * @since JDK 1.6
     */
    void insertLinkCoupon(GoodsTypeEnum gtype,long gid,long goodsBatchId,long goodsCouponId,
                         String link);
    /**
     * 
     * insertRepeatCoupon:导入一条可重复券. <br/>
     *
     * @author xuhengfei
     * @param gtype
     * @param gid
     * @param goodsBatchId
     * @param goodsCouponId
     * @param code
     * @param password
     * @since JDK 1.6
     */
    void insertRepeatCoupon(GoodsTypeEnum gtype,long gid,long goodsBatchId,long goodsCouponId,
                            String code,String password);
    
    
    int updateLinkCoupon(GoodsTypeEnum gtype,long gid,long goodsBatchId,
                         String link);
    
    int updateRepeatCoupon(GoodsTypeEnum gtype,long gid,long goodsBatchId,
                           String code,String password);
    
    
    GoodsCouponEntity selectByCouponId(Long goodsCouponId);
    
    List<GoodsCouponEntity> selectBatchNotUsed(GoodsTypeEnum gtype,long gid,long goodsBatchId,int limit);
    
    GoodsCouponEntity selectOneCouponNotUsed(GoodsTypeEnum gtype,long gid,long goodsBatchId);
    /**
     * 根据批次获取一张券，主要是链接券，重复券获取信息
     *
     * @author xuhengfei
     * @param gtype
     * @param gid
     * @param goodsBatchId
     * @return
     * @since JDK 1.6
     */
    GoodsCouponEntity selectOneByGoodsBatchId(GoodsTypeEnum gtype,long gid,long goodsBatchId);
    
    List<GoodsCouponEntity> selectSearchByCode(GoodsTypeEnum gtype, long gid, long goodsBatchId, String code);
    
    int selectCountByBatch(GoodsTypeEnum gtype,long gid,long goodsBatchId);
    
    int selectCountByBatchNotUsed(GoodsTypeEnum gtype,long gid,long goodsBatchId);
    
    List<GoodsCouponEntity> selectPageByBatchId(GoodsTypeEnum gtype,long gid,long goodsBatchId,int pageSize,int pageIndex);
    
    int updateCouponMarkLocked(GoodsTypeEnum gtype,long gid,long goodsBatchId,long goodsCouponId,long consumerId);
    /**
     * 标记优惠券为已使用
     *
     * @author xuhengfei
     * @param goodsCouponId
     * @param orderId
     * @return
     * @since JDK 1.6
     */
    int updateCoupnoMarkUsed(long goodsCouponId,Long orderId);
    /**
     * 设置回滚优惠劵状态
     * @author xuhengfei
     * @param goodsCouponId
     * @return
     * @since JDK 1.6
     */
    int updateCouponMarkRollback(long goodsCouponId);
    
    public static class CouponFormat{
        private Long goodsCouponId;
        private String code;
        private String password;
        
        public Long getGoodsCouponId() {
            return goodsCouponId;
        }
        
        public void setGoodsCouponId(Long goodsCouponId) {
            this.goodsCouponId = goodsCouponId;
        }
        
        public String getCode() {
            return code;
        }
        
        public void setCode(String code) {
            this.code = code;
        }
        
        public String getPassword() {
            return password;
        }
        
        public void setPassword(String password) {
            this.password = password;
        }
        
    }
}

