/**
 * Project Name:goods-center-biz
 * File Name:PCGCategoryDao.java
 * Package Name:cn.com.duiba.goods.center.biz.dao
 * Date:2016年5月20日上午9:37:35
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.dao;

import java.util.List;

import cn.com.duiba.goods.center.biz.entity.PCGCategoryEntity;

/**
 * ClassName:PCGCategoryDao <br/>
 * Date:     2016年5月20日 上午9:37:35 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface PCGCategoryDao {

    /**
     * 
     * insert:创建一个分类. <br/>
     *
     * @author xuhengfei
     * @param name
     * @return
     * @since JDK 1.6
     */
    Long insert(String name);
    /**
     * 
     * updateName:修改一个分类的名称. <br/>
     *
     * @author xuhengfei
     * @param id
     * @param name
     * @since JDK 1.6
     */
    int updateName(Long id,String name);
    /**
     * 
     * updatePayload:修改一个分类的权重. <br/>
     *
     * @author xuhengfei
     * @param id
     * @param payload
     * @since JDK 1.6
     */
    int updatePayload(Long id,int payload);
    /**
     * 
     * selectAll:查询所有分类. <br/>
     *
     * @author xuhengfei
     * @return
     * @since JDK 1.6
     */
    List<PCGCategoryEntity> selectAll();
    /**
     * 
     * select:单条记录查询. <br/>
     *
     * @author xuhengfei
     * @param id
     * @return
     * @since JDK 1.6
     */
    PCGCategoryEntity select(Long id);
    /**
     * 删除类目
     *
     * @author xuhengfei
     * @param id
     * @return
     * @since JDK 1.6
     */
    int delete(Long id);
    /**
     * 
     * selectByIds:通过多个分类id查询分类列表. <br/>
     *
     * @author zhengjy
     * @return
     * @since JDK 1.6
     */
    List<PCGCategoryEntity> selectByIds(List<Long> categoryIds);
    
}

