/**
 * Project Name:goods-center-biz
 * File Name:PCGFilterConfigDao.java
 * Package Name:cn.com.duiba.goods.center.biz.dao
 * Date:2016年5月20日上午9:56:11
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.dao;

import java.util.List;

import cn.com.duiba.goods.center.biz.entity.PCGCategroySellerGoodsEntity;
import cn.com.duiba.goods.center.biz.entity.PCGFilterConfigEntity;
import cn.com.duiba.goods.center.biz.entity.PlatformCouponGoodsEntity;

/**
 * ClassName:PCGFilterConfigDao <br/>
 * Date:     2016年5月20日 上午9:56:11 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface PCGFilterConfigDao {

    Long insert(long appId,int type,long targetId);
    
    int delete(long appId,int type,long targetId);
    
    PCGFilterConfigEntity select(Long id);
    
    /**
     * 查询app下屏蔽券列表 <br/>
     * @param appId AppId
     * @param type  1:优惠券 2:分类 3:品牌
     * @return 
     */
     List<Long> selectPCGFilterTargetIds(Long appId,Integer type);
     
     /**
      * 查询券属于分类或品牌 <br/>
      * @param goodsId  商品id
      * @return
      */
     public List<PCGCategroySellerGoodsEntity> selectCounponBelong(Long goodsId);
     
     /**
 	 * 查询优惠券，被加入品牌或类别列表 <br/>
 	 * @author zhengjy
 	 * @param appId appId
 	 * @param pageIndex 第几页
 	 * @param pageSize 每页多少条
 	 * @return
 	 */
     List<PlatformCouponGoodsEntity> selectPCGCategroySellerGoodsList(Long appId,int pageSize,int pageIndex);
     /**
  	 * 查询优惠券，被加入品牌或类别count <br/>
  	 * @param appId appId
  	 * @author zhengjy
  	 * @return
  	 */
     public int selectPCGCategroySellerGoodsCount(Long appId);
}

