/**
 * Project Name:goods-center-biz
 * File Name:PCGSellerDao.java
 * Package Name:cn.com.duiba.goods.center.biz.dao
 * Date:2016年5月20日上午9:55:09
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.dao;

import java.util.List;

import cn.com.duiba.goods.center.biz.entity.PCGSellerEntity;

/**
 * ClassName:PCGSellerDao <br/>
 * Date:     2016年5月20日 上午9:55:09 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface PCGSellerDao {
    /**
     * 
     * insert:创建一个品牌. <br/>
     *
     * @author xuhengfei
     * @param name
     * @return
     * @since JDK 1.6
     */
    Long insert(String name,String logo);
    /**
     * 
     * updateName:修改一个品牌的名称. <br/>
     *
     * @author xuhengfei
     * @param id
     * @param name
     * @since JDK 1.6
     */
    int updateNameAndLogo(Long id,String name,String logo);
    /**
     * 
     * updatePayload:修改一个品牌的权重. <br/>
     *
     * @author xuhengfei
     * @param id
     * @param payload
     * @since JDK 1.6
     */
    int updatePayload(Long id,int payload);
    /**
     * 
     * selectAll:查询所有品牌. <br/>
     *
     * @author xuhengfei
     * @return
     * @since JDK 1.6
     */
    List<PCGSellerEntity> selectAll();
    
    /**
     * 
     * select:查询单条. <br/>
     *
     * @author xuhengfei
     * @param id
     * @return
     * @since JDK 1.6
     */
    PCGSellerEntity select(Long id);
    /**
     * 删除一个品牌
     *
     * @author xuhengfei
     * @param id
     * @return
     * @since JDK 1.6
     */
    int delete(Long id);
    /**
     * 
     * selectByIds:通过多个品牌id查询品牌列表. <br/>
     *
     * @author zhengjy
     * @return
     * @since JDK 1.6
     */
    List<PCGSellerEntity> selectByIds(List<Long> sellerIds);
}

