/**
 * Project Name:goods-center-biz
 * File Name:PlatformCouponGoodsDao.java
 * Package Name:cn.com.duiba.goods.center.biz.dao
 * Date:2016年5月19日下午4:10:54
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.dao;

import java.util.List;

import cn.com.duiba.goods.center.api.remoteservice.dto.PCGEditDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGInsertDto;
import cn.com.duiba.goods.center.biz.entity.PlatformCouponGoodsEntity;

/**
 * ClassName:PlatformCouponGoodsDao <br/>
 * Date:     2016年5月19日 下午4:10:54 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface PlatformCouponGoodsDao {
    
    
    /**
     * 
     * insert:插入一条平台券商品信息. <br/>
     *
     * @author xuhengfei
     * @param entity
     * @return
     * @since JDK 1.6
     */
    public int insert(PCGInsertDto entity);
    /**
     * 
     * markDelete:标记删除一个平台券商品. <br/>
     *
     * @author xuhengfei
     * @param pcgId
     * @return
     * @since JDK 1.6
     */
    public int markDelete(Long pcgId);
    /**
     * 
     * updateStatusOnShelf:更新商品为上架状态. <br/>
     *
     * @author xuhengfei
     * @param pcgId
     * @return
     * @since JDK 1.6
     */
    public int updateStatusOnShelf(Long pcgId);
    
    /**
     * 
     * updateStatusOffShelf:更新商品为下架状态. <br/>
     *
     * @author xuhengfei
     * @param pcgId
     * @return
     * @since JDK 1.6
     */
    public int updateStatusOffShelf(Long pcgId);
    /**
     * 编辑商品
     *
     * @author xuhengfei
     * @param pcgId
     * @return
     * @since JDK 1.6
     */
    public int updateEditGoods(Long pcgId,PCGEditDto goods);
    /**
     * 更新商品的券类型
     *
     * @author xuhengfei
     * @param pcgId
     * @param couponType
     * @return
     * @since JDK 1.6
     */
    public int updateCouponType(Long pcgId,int couponType);
    
    public List<PlatformCouponGoodsEntity> selectSearchByName(String namelike);
    
    public PlatformCouponGoodsEntity selectByPcgId(long pcgId);
    /**
     * 批量查询商品
     *
     * @author xuhengfei
     * @param pcgIds
     * @return
     * @since JDK 1.6
     */
    public List<PlatformCouponGoodsEntity> selectByIds(List<Long> pcgIds);
    
    public int selectCountBySearch(String name,int pcgStatus);
    
    public List<PlatformCouponGoodsEntity> selectBySearch(String name,int pcgStatus,int start,int limit);
}

