/**
 * Project Name:goods-center-biz
 * File Name:GoodsCouponDaoImpl.java
 * Package Name:cn.com.duiba.goods.center.biz.dao.impl
 * Date:2016年5月23日下午12:20:25
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.dao.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.biz.dao.BaseCouponDao;
import cn.com.duiba.goods.center.biz.dao.BaseDao;
import cn.com.duiba.goods.center.biz.dao.GoodsCouponDao;
import cn.com.duiba.goods.center.biz.entity.GoodsCouponEntity;

/**
 * ClassName:GoodsCouponDaoImpl <br/>
 * Date:     2016年5月23日 下午12:20:25 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Repository("goodsCouponDao")
public class GoodsCouponDaoImpl extends BaseCouponDao implements GoodsCouponDao {

    
    @Override
    public int insertBatchImport(GoodsTypeEnum gtype, long gid, long goodsBatchId, List<CouponFormat> coupons) {
        
        Map<String, Object> params=getTb1024SuffixParamsMap(gid);
        params.put("gtype", gtype.getGtype());
        params.put("gid", gid);
        params.put("goodsBatchId", goodsBatchId);
        params.put("coupons", coupons);
        params.put("status", GoodsCouponEntity.StatusNew);
        
        return getSqlSession().insert(getStamentNameSpace("insertBatchImport"), params);
        
    }

    @Override
    public void insertLinkCoupon(GoodsTypeEnum gtype, long gid, long goodsBatchId, long goodsCouponId, String link) {
        Map<String, Object> params=getTb1024SuffixParamsMap(gid);
        params.put("gtype", gtype.getGtype());
        params.put("gid", gid);
        params.put("goodsBatchId", goodsBatchId);
        params.put("link", link);
        params.put("goodsCouponId", goodsCouponId);
        params.put("status", GoodsCouponEntity.StatusNew);
        
        getSqlSession().insert(getStamentNameSpace("insertLinkCoupon"), params);
        
    }

    @Override
    public void insertRepeatCoupon(GoodsTypeEnum gtype, long gid, long goodsBatchId, long goodsCouponId, String code,
                                   String password) {
        Map<String, Object> params=getTb1024SuffixParamsMap(gid);
        params.put("gtype", gtype.getGtype());
        params.put("gid", gid);
        params.put("goodsBatchId", goodsBatchId);
        params.put("goodsCouponId", goodsCouponId);
        params.put("code", code);
        params.put("password", password);
        params.put("status", GoodsCouponEntity.StatusNew);
        getSqlSession().insert(getStamentNameSpace("insertRepeatCoupon"), params);
    }

    @Override
    public GoodsCouponEntity selectByCouponId(Long goodsCouponId) {
        Map<String, Object> params=getTb1024ByLast4Number(goodsCouponId);
        params.put("goodsCouponId", goodsCouponId);
        return getSqlSession().selectOne(getStamentNameSpace("selectByCouponId"),params);
    }
    
    @Override
    public int selectCountByBatch(GoodsTypeEnum gtype, long gid, long goodsBatchId) {
        Map<String, Object> params=getTb1024SuffixParamsMap(gid);
        params.put("gtype", gtype.getGtype());
        params.put("gid", gid);
        params.put("goodsBatchId", goodsBatchId);
        
        return getSqlSession().selectOne(getStamentNameSpace("selectCountByBatch"),params);
    }
    @Override
    public int selectCountByBatchNotUsed(GoodsTypeEnum gtype, long gid, long goodsBatchId) {
        Map<String, Object> params=getTb1024SuffixParamsMap(gid);
        params.put("gtype", gtype.getGtype());
        params.put("gid", gid);
        params.put("goodsBatchId", goodsBatchId);
        
        return getSqlSession().selectOne(getStamentNameSpace("selectCountByBatchNotUsed"),params);
    }
    @Override
    public List<GoodsCouponEntity> selectPageByBatchId(GoodsTypeEnum gtype, long gid, long goodsBatchId, int start,
                                                       int limit) {
        Map<String, Object> params=getTb1024SuffixParamsMap(gid);
        params.put("gtype", gtype.getGtype());
        params.put("gid", gid);
        params.put("goodsBatchId", goodsBatchId);
        params.put("start", start);
        params.put("limit", limit);
        
        return getSqlSession().selectList(getStamentNameSpace("selectPageByBatchId"),params);
    }
    
    @Override
    public List<GoodsCouponEntity> selectBatchNotUsed(GoodsTypeEnum gtype, long gid, long goodsBatchId, int limit) {
        Map<String, Object> params=getTb1024SuffixParamsMap(gid);
        params.put("gtype", gtype.getGtype());
        params.put("gid", gid);
        params.put("goodsBatchId", goodsBatchId);
        params.put("limit", limit);
        
        return getSqlSession().selectList(getStamentNameSpace("selectBatchNotUsed"),params);
    }
    
    @Override
    public GoodsCouponEntity selectOneCouponNotUsed(GoodsTypeEnum gtype, long gid, long goodsBatchId) {
        Map<String, Object> params=getTb1024SuffixParamsMap(gid);
        params.put("gtype", gtype.getGtype());
        params.put("gid", gid);
        params.put("goodsBatchId", goodsBatchId);
        
        return getSqlSession().selectOne(getStamentNameSpace("selectOneCouponNotUsed"),params);
    }
    
    @Override
    public int updateCouponMarkLocked(GoodsTypeEnum gtype, long gid, long goodsBatchId, long goodsCouponId,
                                      long consumerId) {
        Map<String, Object> params=getTb1024SuffixParamsMap(gid);
        params.put("gtype", gtype.getGtype());
        params.put("gid", gid);
        params.put("goodsBatchId", goodsBatchId);
        params.put("goodsCouponId", goodsCouponId);
        params.put("consumerId", consumerId);
        return getSqlSession().update(getStamentNameSpace("updateCouponMarkLocked"), params);
    }
    
    @Override
    public int updateCouponMarkRollback(long goodsCouponId) {
        Map<String, Object> params=getTb1024ByLast4Number(goodsCouponId);
        params.put("goodsCouponId", goodsCouponId);
        return getSqlSession().update(getStamentNameSpace("updateCouponMarkRollback"),params);
    }
    
    @Override
    public int updateCoupnoMarkUsed(long goodsCouponId, Long orderId) {
        Map<String, Object> params=getTb1024ByLast4Number(goodsCouponId);
        params.put("goodsCouponId", goodsCouponId);
        params.put("orderId", orderId);
        return getSqlSession().update(getStamentNameSpace("updateCoupnoMarkUsed"), params);
    }
    
    @Override
    public int updateLinkCoupon(GoodsTypeEnum gtype, long gid, long goodsBatchId, String link) {
        Map<String, Object> params=getTb1024SuffixParamsMap(gid);
        params.put("gtype", gtype.getGtype());
        params.put("gid", gid);
        params.put("goodsBatchId", goodsBatchId);
        params.put("link", link);
        
        return getSqlSession().update(getStamentNameSpace("updateLinkCoupon"), params);
    }
    
    @Override
    public int updateRepeatCoupon(GoodsTypeEnum gtype, long gid, long goodsBatchId, String code, String password) {
        Map<String, Object> params=getTb1024SuffixParamsMap(gid);
        params.put("gtype", gtype.getGtype());
        params.put("gid", gid);
        params.put("goodsBatchId", goodsBatchId);
        params.put("code", code);
        params.put("password", password);
        
        return getSqlSession().update(getStamentNameSpace("updateRepeatCoupon"), params);
    }
    
    @Override
    public GoodsCouponEntity selectOneByGoodsBatchId(GoodsTypeEnum gtype, long gid, long goodsBatchId) {
        Map<String, Object> params=getTb1024SuffixParamsMap(gid);
        params.put("gtype", gtype.getGtype());
        params.put("gid", gid);
        params.put("goodsBatchId", goodsBatchId);
        return getSqlSession().selectOne(getStamentNameSpace("selectOneByGoodsBatchId"),params);
    }
    
    @Override
    public List<GoodsCouponEntity> selectSearchByCode(GoodsTypeEnum gtype, long gid, long goodsBatchId, String code) {
        Map<String, Object> params=getTb1024SuffixParamsMap(gid);
        params.put("gtype", gtype.getGtype());
        params.put("gid", gid);
        params.put("goodsBatchId", goodsBatchId);
        params.put("code", code);
        return getSqlSession().selectList(getStamentNameSpace("selectSearchByCode"),params);
    }

}

