/**
 * Project Name:goods-center-biz
 * File Name:PCGCategoryDaoImpl.java
 * Package Name:cn.com.duiba.goods.center.biz.dao.impl
 * Date:2016年5月20日上午11:29:14
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.dao.impl;

import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.goods.center.biz.dao.BaseDao;
import cn.com.duiba.goods.center.biz.dao.PCGCategoryDao;
import cn.com.duiba.goods.center.biz.entity.PCGCategoryEntity;

/**
 * ClassName:PCGCategoryDaoImpl <br/>
 * Date:     2016年5月20日 上午11:29:14 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Repository("pCGCategoryDao")
public class PCGCategoryDaoImpl extends BaseDao implements PCGCategoryDao {

    @Override
    public Long insert(String name) {
        PCGCategoryEntity entity=new PCGCategoryEntity();
        entity.setName(name);
        entity.setPayload(0);
        getSqlSession().insert(getStamentNameSpace("insert"),entity);
        return entity.getId();
    }

    @Override
    public int updateName(Long id, String name) {
        Map<String, Object> params=getBlankParams();
        params.put("id", id);
        params.put("name", name);
        return getSqlSession().update(getStamentNameSpace("updateName"), params);
    }

    @Override
    public int updatePayload(Long id, int payload) {
        Map<String, Object> params=getBlankParams();
        params.put("id", id);
        params.put("payload",payload);
        return getSqlSession().update(getStamentNameSpace("updatePayload"), params);
    }

    @Override
    public List<PCGCategoryEntity> selectAll() {
        return getSqlSession().selectList(getStamentNameSpace("selectAll"));
    }
    
    @Override
    public PCGCategoryEntity select(Long id) {
        return getSqlSession().selectOne(getStamentNameSpace("select"),id);
    }
    
    @Override
    public int delete(Long id) {
        return getSqlSession().delete(getStamentNameSpace("delete"),id);
    }

	@Override
	public List<PCGCategoryEntity> selectByIds(List<Long> categoryIds) {
		Map<String, Object> params=getBlankParams();
        params.put("categoryIds", categoryIds);
		return getSqlSession().selectList(getStamentNameSpace("selectByIds"),params);
	}

}

