/**
 * Project Name:goods-center-biz
 * File Name:PCGSellerDaoImpl.java
 * Package Name:cn.com.duiba.goods.center.biz.dao.impl
 * Date:2016年5月20日上午11:29:56
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.dao.impl;

import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.goods.center.biz.dao.PCGSellerDao;
import cn.com.duiba.goods.center.biz.dao.BaseDao;
import cn.com.duiba.goods.center.biz.entity.PCGCategoryEntity;
import cn.com.duiba.goods.center.biz.entity.PCGSellerEntity;

/**
 * ClassName:PCGSellerDaoImpl <br/>
 * Date:     2016年5月20日 上午11:29:56 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Repository("pCGSellerDao")
public class PCGSellerDaoImpl extends BaseDao implements PCGSellerDao{

    @Override
    public Long insert(String name,String logo) {
        PCGSellerEntity e=new PCGSellerEntity();
        e.setName(name);
        e.setLogo(logo);
        e.setPayload(0);
        
        getSqlSession().insert(getStamentNameSpace("insert"), e);
        return e.getId();
    }

    @Override
    public int updateNameAndLogo(Long id, String name,String logo) {
        Map<String, Object> params=getBlankParams();
        params.put("id", id);
        params.put("name", name);
        params.put("logo", logo);
        return getSqlSession().update(getStamentNameSpace("updateNameAndLogo"), params);
        
    }

    @Override
    public int updatePayload(Long id, int payload) {
        Map<String, Object> params=getBlankParams();
        params.put("id", id);
        params.put("payload", payload);
        return getSqlSession().update(getStamentNameSpace("updatePayload"), params);
    }

    @Override
    public List<PCGSellerEntity> selectAll() {
        
        return getSqlSession().selectList(getStamentNameSpace("selectAll"));
    }
    
    @Override
    public PCGSellerEntity select(Long id) {
        return getSqlSession().selectOne(getStamentNameSpace("select"),id);
    }
    
    @Override
    public int delete(Long id) {
        return getSqlSession().delete(getStamentNameSpace("delete"), id);
    }

	@Override
	public List<PCGSellerEntity> selectByIds(List<Long> sellerIds) {
		Map<String, Object> params=getBlankParams();
        params.put("sellerIds", sellerIds);
		return getSqlSession().selectList(getStamentNameSpace("selectByIds"),params);
	}

}

