/**
 * Project Name:goods-center-biz
 * File Name:RemotePCGSellerGoodsBackendServiceImpl.java
 * Package Name:cn.com.duiba.goods.center.biz.remoteservice.impl
 * Date:2016年5月26日下午7:02:09
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.remoteservice.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.goods.center.api.remoteservice.RemotePCGSellerBackendService;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGSellerDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGSellerGoodsDto;
import cn.com.duiba.goods.center.biz.entity.PCGSellerEntity;
import cn.com.duiba.goods.center.biz.entity.PCGSellerGoodsEntity;
import cn.com.duiba.goods.center.biz.entity.PlatformCouponGoodsEntity;
import cn.com.duiba.goods.center.biz.service.PCGSellerGoodsService;
import cn.com.duiba.goods.center.biz.service.PlatformCouponGoodsService;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemotePCGSellerGoodsBackendServiceImpl <br/>
 * Date:     2016年5月26日 下午7:02:09 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Service("remotePCGSellerBackendService")
public class RemotePCGSellerBackendServiceImpl implements RemotePCGSellerBackendService{
    private static Logger log=LoggerFactory.getLogger(RemotePCGSellerBackendServiceImpl.class);
    @Autowired
    private PCGSellerGoodsService pcgSellerGoodsService;
    @Autowired
    private PlatformCouponGoodsService platformCouponGoodsService;
    
    
    @Override
    public DubboResult<Boolean> addGoods2Seller(long pcgId,long sellerId) {
        try{
            boolean ret=pcgSellerGoodsService.addGoods2Seller(sellerId, pcgId);
            return DubboResult.successResult(ret);
        }catch(Exception e){
            log.error("addRelation sellerId="+sellerId+",pcgId="+pcgId,e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> remoteGoodsFromSeller(long pcgId,long sellerId) {
        try{
            boolean ret=pcgSellerGoodsService.removeGoodsFromSeller(sellerId, pcgId);
            return DubboResult.successResult(ret);
        }catch(Exception e){
            log.error("deleteRelation sellerId="+sellerId+",pcgId="+pcgId,e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> removeSeller(long sellerId) {
        try{
            boolean ret=pcgSellerGoodsService.removeSeller(sellerId);
            return DubboResult.successResult(ret);
        }catch(Exception e){
            log.error("deleteAllBySellerId sellerId="+sellerId,e);
            return DubboResult.failResult(e.getMessage());
        }
    }
/*
    @Override
    public DubboResult<Boolean> deleteAllByPcgId(long pcgId) {
        try{
            boolean ret=pcgSellerGoodsService.deleteAllByPcgId(pcgId);
            return DubboResult.successResult(ret);
        }catch(Exception e){
            log.error("deleteAllByPcgId pcgId="+pcgId,e);
            return DubboResult.failResult(e.getMessage());
        }
    }
    */

    @Override
    public DubboResult<Long> createSeller(String name,String logo) {
        try {
            Long id=pcgSellerGoodsService.addSeller(name, logo);
            return DubboResult.successResult(id);
        } catch (Exception e) {
            log.error("createSeller name="+name+",logo="+logo,e);
            return DubboResult.failResult(e.getMessage());
        }
    }


    @Override
    public DubboResult<List<PCGSellerDto>> findAll() {
        try {
            List<PCGSellerDto> ret=new ArrayList<>();
            List<PCGSellerEntity> list=pcgSellerGoodsService.findAll();
            for(PCGSellerEntity e:list){
                PCGSellerDto dto=new PCGSellerDto();
                dto.setId(e.getId());
                dto.setLogo(e.getLogo());
                dto.setName(e.getName());
                dto.setPayload(e.getPayload());
                ret.add(dto);
            }
            return DubboResult.successResult(ret);
        } catch (Exception e) {
            log.error("findAll",e);
            return DubboResult.failResult(e.getMessage());
        }
    }
    
    @Override
    public DubboResult<Boolean> editSellerNameAndLogo(long sellerId, String name, String logo) {
        
        try {
            pcgSellerGoodsService.updateSellerNameAndLogo(sellerId, name, logo);
            return DubboResult.successResult(true);
        } catch (Exception e) {
            log.error("editSellerNameAndLogo sellerId="+sellerId+",name="+name+",logo="+logo,e);
            return DubboResult.failResult(e.getMessage());
        }
    }
    
    @Override
    public DubboResult<List<PCGSellerGoodsDto>> findAllBySellerId(long sellerId) {
        try {
            List<PCGSellerGoodsDto> ret=new ArrayList<>();
            List<PCGSellerGoodsEntity> list= pcgSellerGoodsService.findAllGoodsBySeller(sellerId);
            List<Long> pcgIds=new ArrayList<>();
            for(PCGSellerGoodsEntity e:list){
                PCGSellerGoodsDto dto=new PCGSellerGoodsDto();
                dto.setId(e.getId());
                dto.setPayload(e.getPayload());
                dto.setPcgId(e.getPcgId());
                dto.setSellerId(e.getSellerId());
                ret.add(dto);
                
                pcgIds.add(dto.getPcgId());
            }
            
            Map<Long,  PlatformCouponGoodsEntity> map=platformCouponGoodsService.findByIds(pcgIds);
            for(PCGSellerGoodsDto dto:ret){
                dto.setTitle(map.get(dto.getPcgId()).getTitle());
            }
            
            return DubboResult.successResult(ret);
        } catch (Exception e) {
            log.error("findAllBySellerId sellerId="+sellerId,e);
            return DubboResult.failResult(e.getMessage());
        }
    }
    
    @Override
    public DubboResult<Boolean> sortSellerGoods(List<PCGSellerGoodsDto> list) {
        
        try {
            pcgSellerGoodsService.sortSellerGoods(list);;
            return DubboResult.successResult(true);
        } catch (Exception e) {
            log.error("sortSellerGoods",e);
            return DubboResult.failResult(e.getMessage());
        }
    }
    
    @Override
    public DubboResult<Boolean> sortSellers(List<PCGSellerDto> sellers) {
        
        try {
            pcgSellerGoodsService.sortSellers(sellers);;
            return DubboResult.successResult(true);
        } catch (Exception e) {
            log.error("sortSellers",e);
            return DubboResult.failResult(e.getMessage());
        }
    }


}

