/**
 * Project Name:goods-center-biz
 * File Name:GoodsCouponService.java
 * Package Name:cn.com.duiba.goods.center.biz.service
 * Date:2016年5月25日下午12:23:22
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.service;

import java.util.List;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.tool.Page;
import cn.com.duiba.goods.center.biz.dao.GoodsCouponDao.CouponFormat;
import cn.com.duiba.goods.center.biz.entity.GoodsBatchEntity;
import cn.com.duiba.goods.center.biz.entity.GoodsCouponEntity;
import cn.com.duiba.goods.center.common.GoodsException;

/**
 * ClassName:GoodsCouponService <br/>
 * Date:     2016年5月25日 下午12:23:22 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface GoodsCouponService {

    public Boolean updateLinkBatch(GoodsTypeEnum gtype, long gid, Long batchId, String link);

    public Boolean updateRepeatBatch(GoodsTypeEnum gtype, long gid, Long batchId, String code, String password);
    

    public Integer importNormalCoupons(GoodsTypeEnum gtype, long gid, Long batchId, List<CouponFormat> coupons);

    public void importLinkCoupon(GoodsTypeEnum gtype,long gid,long goodsBatchId,long goodsCouponId,String link);
    
    public void importRepeatCoupon(GoodsTypeEnum gtype,long gid,long goodsBatchId,long goodsCouponId,String code,String password);
    
    public Page<GoodsCouponEntity> findPage(GoodsTypeEnum gtype, long gid, long batchId, int pageSize,
                                                      int pageIndex) ;
    /**
     * 查询一张优惠劵
     *
     * @author xuhengfei
     * @param goodsCouponId
     * @return
     * @since JDK 1.6
     */
    public GoodsCouponEntity find(Long goodsCouponId);
    /**
     * 查询剩余库存数
     *
     * @author xuhengfei
     * @param gtype
     * @param gid
     * @param batchId
     * @return
     * @since JDK 1.6
     */
    public long findNotUsedCount(GoodsBatchEntity batch);
    /**
     * 查询一个批次的所有库存数(包含已经消耗的)
     *
     * @author xuhengfei
     * @param gtype
     * @param gid
     * @param batchId
     * @return
     * @since JDK 1.6
     */
    public long findTotalAllCount(GoodsTypeEnum gtype,long gid,long batchId);
    /**
     * 从数据库获取一条优惠劵,并标记为已使用
     *
     * @author xuhengfei
     * @param gtype
     * @param gid
     * @param batchId
     * @return 
     * @exception 售罄异常，其他异常
     * @since JDK 1.6
     */
    public GoodsCouponEntity takeNormalCoupon(GoodsTypeEnum gtype, GoodsBatchEntity batch,long consumerId);
    
    public GoodsCouponEntity takeLinkCoupon(GoodsTypeEnum gtype,GoodsBatchEntity batch,long consumerId,String bizNum);
    
    public GoodsCouponEntity takeRepeatCoupon(GoodsTypeEnum gtype,GoodsBatchEntity batch,long consumerId,String bizNum);
    /**
     * 确认完成一张优惠劵的发放
     *
     * @author xuhengfei
     * @param couponId
     * @param orderId
     * @return
     * @since JDK 1.6
     */
    public void completeCoupon(Long couponId, long orderId);
    /**
     * 回滚返还一张优惠劵
     *
     * @author xuhengfei
     * @param couponId
     * @return
     * @since JDK 1.6
     */
    public Boolean rollbackNormalCoupon(Long couponId);
    
   
    /**
     * 
     * 这个批次是否还有库存
     *
     * @author xuhengfei
     * @param gtype
     * @param gid
     * @param batchId
     * @return
     * @since JDK 1.6
     
    public boolean isBatchHaveStock(GoodsTypeEnum gtype,GoodsBatchEntity batch);
    */
    /**
     * 链接券和重复券，根据批次，查询信息
     *
     * @author xuhengfei
     * @param gtype
     * @param gid
     * @param goodsBatchId
     * @return
     * @since JDK 1.6
     */
    public GoodsCouponEntity findOneByGoodsBatchId(GoodsTypeEnum gtype,long gid,long goodsBatchId);
    
    public List<GoodsCouponEntity> searchByCode(GoodsTypeEnum gtype,long gid,long goodsBatchId,String code);
    
}

