package cn.com.duiba.goods.center.biz.service;

import java.util.List;

import cn.com.duiba.goods.center.api.remoteservice.tool.Page;
import cn.com.duiba.goods.center.biz.entity.PCGCategoryEntity;
import cn.com.duiba.goods.center.biz.entity.PCGCategroySellerGoodsEntity;
import cn.com.duiba.goods.center.biz.entity.PCGFilterConfigEntity;
import cn.com.duiba.goods.center.biz.entity.PCGSellerEntity;
import cn.com.duiba.goods.center.biz.entity.PlatformCouponGoodsEntity;

/**
 * ClassName:PCGFilterConfigService <br/>
 * Date:     2016年6月13日 下午12:23:22 <br/>
 * @author   zhengjy
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface PCGFilterConfigService {
	
	Long insert(long appId,int type,long targetId);
    
    int delete(long appId,int type,long targetId);
    
    PCGFilterConfigEntity select(Long id);
	 
	/**
     * 查询app下屏蔽券列表
     * @author zhengjy
     * @param appId AppId
     * @return PlatformCouponGoodsEntity
     */
    public List<PlatformCouponGoodsEntity> findGoodsFilterList(Long appId);
     
    /**
     * 查询app下屏蔽分类列表
     * @author zhengjy
     * @param appId AppId
     * @return PCGCategoryEntity
     */
    public List<PCGCategoryEntity> findCategoryFilterList(Long appId);
     
    /**
     * 查询app下屏蔽品牌列表
     * @author zhengjy
     * @param appId AppId
     * @return PCGCategoryEntity
     */
    public List<PCGSellerEntity> findSellerFilterList(Long appId);
    
    /**
     * 查询券属于分类或品牌
     * @param goodsId  商品id
     * @return
     */
    public List<PCGCategroySellerGoodsEntity> findCounponBelong(Long goodsId);
 
    /**
 	 * 查询优惠券，被加入品牌或类别列表 <br/>
 	 * @author zhengjy
 	 * @param appId appId
 	 * @param pageIndex 第几页
 	 * @param pageSize 每页多少条
 	 * @return
 	 */
    Page<PlatformCouponGoodsEntity> selectPCGCategroySellerGoodsList(Long appId,int pageSize,int pageIndex);
    
    /**
     * 查询app下屏蔽券列表 <br/>
     * @param appId AppId
     * @param type  1:优惠券 2:分类 3:品牌
     * @return 
     */
     List<Long> selectPCGFilterTargetIds(Long appId,Integer type);
   
}
