/**
 * Project Name:goods-center-biz
 * File Name:PCGSellerGoodsService.java
 * Package Name:cn.com.duiba.goods.center.biz.service
 * Date:2016年5月26日下午7:03:10
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.service;

import java.util.List;

import cn.com.duiba.goods.center.api.remoteservice.dto.PCGSellerDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGSellerGoodsDto;
import cn.com.duiba.goods.center.biz.entity.PCGSellerEntity;
import cn.com.duiba.goods.center.biz.entity.PCGSellerGoodsEntity;

/**
 * ClassName:PCGSellerGoodsService <br/>
 * Date:     2016年5月26日 下午7:03:10 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface PCGSellerGoodsService {
    
    /**
     * 
     * 创建一个品牌. <br/>
     *
     * @author xuhengfei
     * @param name
     * @return
     * @since JDK 1.6
     */
    Long addSeller(String name,String logo);
    /**
     * 
     * 修改一个品牌的名称. <br/>
     *
     * @author xuhengfei
     * @param id
     * @param name
     * @since JDK 1.6
     */
    void updateSellerNameAndLogo(Long id,String name,String logo);
    /**
     * 
     * updatePayload:修改一个品牌的权重. <br/>
     *
     * @author xuhengfei
     * @param id
     * @param payload
     * @since JDK 1.6
     */
    void updateSellerPayload(Long id,int payload);
    /**
     * 
     * selectAll:查询所有品牌. <br/>
     *
     * @author xuhengfei
     * @return
     * @since JDK 1.6
     */
    List<PCGSellerEntity> findAll();
    /**
     * 
     * select:单条记录查询. <br/>
     *
     * @author xuhengfei
     * @param id
     * @return
     * @since JDK 1.6
     */
    PCGSellerEntity findSeller(Long id);


    
    /**
     * 将商品添加到品牌中
     *
     * @author xuhengfei
     * @param pcgId
     * @param categoryId
     * @return
     * @since JDK 1.6
     */
    Boolean addGoods2Seller(long sellerId,long pcgId);
    /**
     * 将商品从品牌中删除
     *
     * @author xuhengfei
     * @param pcgId
     * @param categoryId
     * @return
     * @since JDK 1.6
     */
    Boolean removeGoodsFromSeller(long sellerId,long pcgId);
    /**
     * 删除一个品牌
     *
     * @author xuhengfei
     * @param categoryId
     * @return
     * @since JDK 1.6
     */
    Boolean removeSeller(long sellerId);
    
    /**
     * 如果一个商品被删除，这个商品相关的品牌关系都需要删除
     *
     * @author xuhengfei
     * @param pcgId
     * @return
     * @since JDK 1.6
     */
    Boolean deleteAllByPcgId(long pcgId);
    
    List<PCGSellerGoodsEntity> findAllGoodsBySeller(long sellerId);
    
    /**
     * 对类目进行批量排序
     *
     * @author xuhengfei
     * @param categories
     * @since JDK 1.6
     */
    void sortSellers(List<PCGSellerDto> sellers);
    /**
     * 对类目下的商品进行批量排序
     *
     * @author xuhengfei
     * @param list
     * @since JDK 1.6
     */
    void sortSellerGoods(List<PCGSellerGoodsDto> list);
}

