/**
 * Project Name:goods-center-biz
 * File Name:GoodsContentServiceImpl.java
 * Package Name:cn.com.duiba.goods.center.biz.service.impl
 * Date:2016年5月30日上午9:45:09
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.biz.dao.GoodsContentDao;
import cn.com.duiba.goods.center.biz.entity.GoodsContentEntity;
import cn.com.duiba.goods.center.biz.service.GoodsContentService;

/**
 * ClassName:GoodsContentServiceImpl <br/>
 * Date:     2016年5月30日 上午9:45:09 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Service("goodsContentService")
public class GoodsContentServiceImpl  implements GoodsContentService{
    @Autowired
    private GoodsContentDao goodsContentDao;
    
    @Override
    public GoodsContentEntity findByGoods(GoodsTypeEnum gtype, long gid) {
        return goodsContentDao.select(gtype.getGtype(), gid);
    }

    @Override
    public void addContent(GoodsTypeEnum gtype, long gid, String content) {
        goodsContentDao.insert(gtype.getGtype(), gid, content);
    }

    @Override
    public void updateContent(GoodsTypeEnum gtype, long gid, String content) {
        goodsContentDao.updateContent(gtype.getGtype(), gid, content);
    }

}

