/**
 * Project Name:goods-center-biz
 * File Name:PCGCategoryGoodsServiceImpl.java
 * Package Name:cn.com.duiba.goods.center.biz.service.impl
 * Date:2016年5月26日下午6:56:13
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import cn.com.duiba.goods.center.api.remoteservice.dto.PCGCategoryDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGCategoryGoodsDto;
import cn.com.duiba.goods.center.biz.dao.PCGCategoryDao;
import cn.com.duiba.goods.center.biz.dao.PCGCategoryGoodsDao;
import cn.com.duiba.goods.center.biz.entity.PCGCategoryEntity;
import cn.com.duiba.goods.center.biz.entity.PCGCategoryGoodsEntity;
import cn.com.duiba.goods.center.biz.service.PCGCategoryGoodsService;

/**
 * ClassName:PCGCategoryGoodsServiceImpl <br/>
 * Date:     2016年5月26日 下午6:56:13 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Service("pCGCategoryGoodsService")
public class PCGCategoryGoodsServiceImpl implements PCGCategoryGoodsService{
    @Autowired
    private PCGCategoryGoodsDao pcgCategoryGoodsDao;
    @Autowired
    private PCGCategoryDao pcgCategoryDao;
    
    @Override
    public Boolean addGoods2Category(long pcgId, long categoryId) {
        int max=pcgCategoryGoodsDao.selectMaxPayloadByCategory(categoryId);
        int ret=pcgCategoryGoodsDao.insertGoods2Category(pcgId, categoryId,max+1);
        if(ret==1){
            return true;
        }else{
            return false;
        }
    }
    
    @Override
    public Boolean removeGoodsFromCategory(long pcgId, long categoryId) {
        int ret=pcgCategoryGoodsDao.deleteGoods2Category(pcgId, categoryId);
        if(ret==1){
            return true;
        }else{
            return false;
        }
    }
    @Override
    @Transactional("pcg")
    public Boolean removeCategory(long categoryId) {
        pcgCategoryDao.delete(categoryId);
        pcgCategoryGoodsDao.deleteCategoryRelation(categoryId);
        return true;
    }

    @Override
    public Boolean deleteAllByPcgId(long pcgId) {
        pcgCategoryGoodsDao.deleteGoodsRelation(pcgId);
        return true;
    }

    @Override
    public Long addCategory(String name) {
        return pcgCategoryDao.insert(name);
    }

    @Override
    public void updateCategoryName(Long id, String name) {
        pcgCategoryDao.updateName(id, name);
    }

    @Override
    public void updateCategoryPayload(Long id, int payload) {
        pcgCategoryDao.updatePayload(id, payload);
    }

    @Override
    public List<PCGCategoryEntity> findAll() {
        return pcgCategoryDao.selectAll();
    }

    @Override
    public PCGCategoryEntity findCategory(Long id) {
        return pcgCategoryDao.select(id);
    }

    @Override
    public void sortCategories(List<PCGCategoryDto> categories) {
        for(PCGCategoryDto dto:categories){
            pcgCategoryDao.updatePayload(dto.getId(), dto.getPayload());
        }
    }
    
    @Override
    public void sortCategoryGoods(List<PCGCategoryGoodsDto> list) {
        for(PCGCategoryGoodsDto dto:list){
            pcgCategoryGoodsDao.updatePayload(dto.getCategoryId(), dto.getPcgId(), dto.getPayload());
        }
    }
    @Override
    public List<PCGCategoryGoodsEntity> findAllGoodsByCategory(long categoryId) {
        return pcgCategoryGoodsDao.selectByCategory(categoryId);
    }
}

