package cn.com.duiba.goods.center.biz.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.goods.center.api.remoteservice.dto.PCGFilterConfigDto;
import cn.com.duiba.goods.center.api.remoteservice.tool.Page;
import cn.com.duiba.goods.center.biz.dao.PCGCategoryDao;
import cn.com.duiba.goods.center.biz.dao.PCGFilterConfigDao;
import cn.com.duiba.goods.center.biz.dao.PCGSellerDao;
import cn.com.duiba.goods.center.biz.dao.PlatformCouponGoodsDao;
import cn.com.duiba.goods.center.biz.entity.PCGCategoryEntity;
import cn.com.duiba.goods.center.biz.entity.PCGCategroySellerGoodsEntity;
import cn.com.duiba.goods.center.biz.entity.PCGFilterConfigEntity;
import cn.com.duiba.goods.center.biz.entity.PCGSellerEntity;
import cn.com.duiba.goods.center.biz.entity.PlatformCouponGoodsEntity;
import cn.com.duiba.goods.center.biz.service.PCGFilterConfigService;
/**
 * ClassName:PCGFilterConfigServiceImpl <br/>
 * Date:     2016年6月13日 下午12:23:22 <br/>
 * @author   zhengjy
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Service
public class PCGFilterConfigServiceImpl implements PCGFilterConfigService{
	@Autowired
	private PCGFilterConfigDao pCGFilterConfigDao;
	@Autowired
	private PlatformCouponGoodsDao platformCouponGoodsDao;
	@Autowired
	private PCGCategoryDao pCGCategoryDao;
	@Autowired
	private PCGSellerDao pCGSellerDao;

	@Override
	public List<PlatformCouponGoodsEntity> findGoodsFilterList(Long appId) {
		List<Long> pcgIds = pCGFilterConfigDao.selectPCGFilterTargetIds(appId, PCGFilterConfigDto.goodsType);
		return platformCouponGoodsDao.selectByIds(pcgIds);
	}

	@Override
	public List<PCGCategoryEntity> findCategoryFilterList(Long appId) {
		List<Long> categoryIds = pCGFilterConfigDao.selectPCGFilterTargetIds(appId, PCGFilterConfigDto.categoryType);
		return pCGCategoryDao.selectByIds(categoryIds);
	}

	@Override
	public List<PCGSellerEntity> findSellerFilterList(Long appId) {
		List<Long> sellerIds = pCGFilterConfigDao.selectPCGFilterTargetIds(appId, PCGFilterConfigDto.sellerType);
		return pCGSellerDao.selectByIds(sellerIds);
	}

	@Override
	public List<PCGCategroySellerGoodsEntity> findCounponBelong(Long goodsId) {
		return pCGFilterConfigDao.selectCounponBelong(goodsId);
	}

	@Override
	public Long insert(long appId, int type, long targetId) {
		return pCGFilterConfigDao.insert(appId, type, targetId);
	}

	@Override
	public int delete(long appId, int type, long targetId) {
		return pCGFilterConfigDao.delete(appId, type, targetId);
	}

	@Override
	public PCGFilterConfigEntity select(Long id) {
		return pCGFilterConfigDao.select(id);
	}

	@Override
	public Page<PlatformCouponGoodsEntity> selectPCGCategroySellerGoodsList(
			Long appId, int pageSize, int pageIndex) {
		int start=pageSize*(pageIndex-1);
        int limit=pageSize;
        int total=pCGFilterConfigDao.selectPCGCategroySellerGoodsCount(appId);
        List<PlatformCouponGoodsEntity> list=pCGFilterConfigDao.selectPCGCategroySellerGoodsList(appId, limit, start);
        Page<PlatformCouponGoodsEntity> page=new Page<>(pageSize, pageIndex);
        page.setList(list);
        page.setTotalCount(total);
        page.setTotalPages(total%pageSize==0?total/pageSize:(total/pageSize+1));
        return page;
	}

	@Override
	public List<Long> selectPCGFilterTargetIds(Long appId, Integer type) {
		return pCGFilterConfigDao.selectPCGFilterTargetIds(appId, type);
	}


}
