/**
 * Project Name:goods-center-biz
 * File Name:PCGSellerGoodsServiceImpl.java
 * Package Name:cn.com.duiba.goods.center.biz.service.impl
 * Date:2016年5月26日下午7:04:22
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import cn.com.duiba.goods.center.api.remoteservice.dto.PCGSellerDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGSellerGoodsDto;
import cn.com.duiba.goods.center.biz.dao.PCGSellerDao;
import cn.com.duiba.goods.center.biz.dao.PCGSellerGoodsDao;
import cn.com.duiba.goods.center.biz.entity.PCGSellerEntity;
import cn.com.duiba.goods.center.biz.entity.PCGSellerGoodsEntity;
import cn.com.duiba.goods.center.biz.service.PCGSellerGoodsService;

/**
 * ClassName:PCGSellerGoodsServiceImpl <br/>
 * Date:     2016年5月26日 下午7:04:22 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Service("pCGSellerGoodsService")
public class PCGSellerGoodsServiceImpl implements PCGSellerGoodsService{
    @Autowired
    private PCGSellerGoodsDao pcgSellerGoodsDao;
    @Autowired
    private PCGSellerDao pcgSellerDao;
    @Override
    public Boolean addGoods2Seller(long sellerId, long pcgId) {
        int max=pcgSellerGoodsDao.selectMaxPayloadBySellerId(sellerId);
        int ret=pcgSellerGoodsDao.insertGoods2Seller(pcgId, sellerId,max+1);
        if(ret==1){
            return true;
        }else{
            return false;
        }
    }

    @Override
    public Boolean removeGoodsFromSeller(long sellerId, long pcgId) {
        int ret=pcgSellerGoodsDao.deleteGoods2Seller(pcgId, sellerId);
        if(ret==1){
            return true;
        }else{
            return false;
        }
    }
    
    @Override
    @Transactional("pcg")
    public Boolean removeSeller(long sellerId) {
        pcgSellerDao.delete(sellerId);
        pcgSellerGoodsDao.deleteSellerRelation(sellerId);
        return true;
    }


    @Override
    public Boolean deleteAllByPcgId(long pcgId) {
        pcgSellerGoodsDao.deleteGoodsRelation(pcgId);
        return true;
    }
    
    @Override
    public Long addSeller(String name,String logo) {
        return pcgSellerDao.insert(name, logo);
    }

    @Override
    public List<PCGSellerEntity> findAll() {
        return pcgSellerDao.selectAll();
    }
    @Override
    public List<PCGSellerGoodsEntity> findAllGoodsBySeller(long sellerId) {
        return pcgSellerGoodsDao.selectBySeller(sellerId);
    }
    @Override
    public PCGSellerEntity findSeller(Long id) {
        return pcgSellerDao.select(id);
    }
    
    @Override
    public void sortSellerGoods(List<PCGSellerGoodsDto> list) {
        for(PCGSellerGoodsDto dto:list){
            pcgSellerGoodsDao.updatePayload(dto.getSellerId(), dto.getPcgId(), dto.getPayload());
        }
    }
    
    @Override
    public void sortSellers(List<PCGSellerDto> sellers) {
        for(PCGSellerDto dto:sellers){
            pcgSellerDao.updatePayload(dto.getId(), dto.getPayload());
        }
    }
    
    @Override
    public void updateSellerPayload(Long id, int payload) {
        pcgSellerDao.updatePayload(id, payload);
    }
    
    @Override
    public void updateSellerNameAndLogo(Long id, String name,String logo) {
        pcgSellerDao.updateNameAndLogo(id, name, logo);
    }
}

