/**
 * Project Name:goods-center-biz
 * File Name:GoodsBatchDao.java
 * Package Name:cn.com.duiba.goods.center.biz.dao
 * Date:2016年5月23日上午11:52:58
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.dao;

import java.util.Date;
import java.util.List;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.enums.CouponType;
import cn.com.duiba.goods.center.biz.entity.GoodsBatchEntity;

/**
 * ClassName:GoodsBatchDao <br/>
 * Date:     2016年5月23日 上午11:52:58 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface GoodsBatchDao {
    /**
     * 
     * insert:创建一个批次. <br/>
     *
     * @author xuhengfei
     * @param gtype
     * @param gid
     * @param batchType
     * @param startDay
     * @param endDay
     * @return
     * @since JDK 1.6
     */
    Long insert(GoodsTypeEnum gtype,Long gid,CouponType batchType,Date startDay,Date endDay);
    /**
     * 
     * select:根据id查询一条批次信息. <br/>
     *
     * @author xuhengfei
     * @param id
     * @return
     * @since JDK 1.6
     */
    GoodsBatchEntity select(Long id);
    /**
     * 不包含已删除的批次
     *
     * @author xuhengfei
     * @param gtype
     * @param gid
     * @return
     * @since JDK 1.6
     */
    List<GoodsBatchEntity> selectNotDeletedByGtypeGid(GoodsTypeEnum gtype,long gid);
    /**
     * 不包含已删除和已过期的批次
     *
     * @author xuhengfei
     * @param gtype
     * @param gid
     * @return
     * @since JDK 1.6
     */
    List<GoodsBatchEntity> selectNotDeletedNotExpiredGtypeGid(GoodsTypeEnum gtype,long gid);
    
    /**
     * 
     * updateImportingYes:标记为正在导入中. <br/>
     *
     * @author xuhengfei
     * @param id
     * @since JDK 1.6
     */
    void updateImportingYes(Long id);
    /**
     * 
     * updateImportingNo:标记为没有在导入中. <br/>
     *
     * @author xuhengfei
     * @param id
     * @since JDK 1.6
     */
    void updateImportingNo(Long id);
    
    int updateStatusUsed(Long id);
    
    int updateStatusUsing(Long id);
    
    int updateStatusNotUsed(Long id);
    /**
     * 逻辑删除一个批次
     *
     * @author xuhengfei
     * @param id
     * @since JDK 1.6
     */
    int deleteBatch(GoodsTypeEnum gtype,long gid,Long goodsBatchId);
    
    
    int updateStockId(GoodsTypeEnum gtype,long gid,Long goodsBatchId,Long stockId);
    
    
}

