/**
 * Project Name:goods-center-biz
 * File Name:GoodsContentDaoImpl.java
 * Package Name:cn.com.duiba.goods.center.biz.dao.impl
 * Date:2016年5月20日上午11:27:58
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.dao.impl;

import java.util.HashMap;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.goods.center.biz.dao.BaseDao;
import cn.com.duiba.goods.center.biz.dao.GoodsContentDao;
import cn.com.duiba.goods.center.biz.entity.GoodsContentEntity;

/**
 * ClassName:GoodsContentDaoImpl <br/>
 * Date:     2016年5月20日 上午11:27:58 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Repository("goodsContentDao")
public class GoodsContentDaoImpl extends BaseDao implements GoodsContentDao{

    @Override
    public int insert(int gtype, long gid, String content) {
        Map<String, Object> params=new HashMap<String, Object>();
        params.put("gtype", gtype);
        params.put("gid", gid);
        params.put("content", content);
        
        return getSqlSession().insert(getStamentNameSpace("insert"), params);
    }

    @Override
    public int updateContent(int gtype, long gid, String content) {
        Map<String, Object> params=new HashMap<String, Object>();
        params.put("gtype", gtype);
        params.put("gid", gid);
        params.put("content", content);
        
        return getSqlSession().update(getStamentNameSpace("updateContent"), params);
    }
    
    @Override
    public GoodsContentEntity select(int gtype, long gid) {
        Map<String, Object> params=new HashMap<String, Object>();
        params.put("gtype", gtype);
        params.put("gid", gid);
        
        return getSqlSession().selectOne(getStamentNameSpace("select"),params);
    }

}

