/**
 * Project Name:goods-center-biz
 * File Name:PCGFilterConfigDaoImpl.java
 * Package Name:cn.com.duiba.goods.center.biz.dao.impl
 * Date:2016年5月20日上午11:30:31
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.dao.impl;

import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.goods.center.biz.dao.BaseDao;
import cn.com.duiba.goods.center.biz.dao.PCGFilterConfigDao;
import cn.com.duiba.goods.center.biz.entity.PCGCategroySellerGoodsEntity;
import cn.com.duiba.goods.center.biz.entity.PCGFilterConfigEntity;
import cn.com.duiba.goods.center.biz.entity.PlatformCouponGoodsEntity;

/**
 * ClassName:PCGFilterConfigDaoImpl <br/>
 * Date:     2016年5月20日 上午11:30:31 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Repository("pCGFilterConfigDao")
public class PCGFilterConfigDaoImpl extends BaseDao implements  PCGFilterConfigDao{

    @Override
    public Long insert(long appId, int type, long targetId) {
        
        PCGFilterConfigEntity e=new PCGFilterConfigEntity();
        e.setAppId(appId);
        e.setType(type);
        e.setTargetId(targetId);
        
        getSqlSession().insert(getStamentNameSpace("insert"), e);
        
        return e.getId();
    }

    @Override
    public int delete(long appId, int type, long targetId) {
        Map<String, Object> params=getBlankParams();
        params.put("appId", appId);
        params.put("type", type);
        params.put("targetId", targetId);
        return getSqlSession().delete(getStamentNameSpace("delete"), params);
    }

    @Override
    public PCGFilterConfigEntity select(Long id) {
        return getSqlSession().selectOne(getStamentNameSpace("select"),id);
    }


	

	public List<Long> selectPCGFilterTargetIds(Long appId, Integer type) {
		Map<String, Object> params=getBlankParams();
        params.put("appId", appId);
        params.put("type", type);
		return getSqlSession().selectList(getStamentNameSpace("selectPCGFilterTargetIds"), params);
	}

	@Override
	public List<PCGCategroySellerGoodsEntity> selectCounponBelong(Long goodsId) {
		Map<String, Object> params=getBlankParams();
        params.put("goodsId", goodsId);
		return getSqlSession().selectList(getStamentNameSpace("selectCounponBelong"), params);
	}

	@Override
	public List<PlatformCouponGoodsEntity> selectPCGCategroySellerGoodsList(Long appId,int pageSize,
			int pageIndex) {
		Map<String, Object> params=getBlankParams();
        params.put("start",pageIndex);
        params.put("limit", pageSize);
        params.put("appId", appId);
        return getSqlSession().selectList(getStamentNameSpace("selectPCGCategroySellerGoods"),params);
	}

	@Override
	public int selectPCGCategroySellerGoodsCount(Long appId) {
		Map<String, Object> params=getBlankParams();
        params.put("appId", appId);
		return getSqlSession().selectOne(getStamentNameSpace("selectPCGCategroySellerGoodsCount"));
	}
}

