/**
 * Project Name:goods-center-biz
 * File Name:GoodsBatchEntity.java
 * Package Name:cn.com.duiba.goods.center.biz.entity
 * Date:2016年5月23日上午11:10:47
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.entity;

import java.util.Date;

/**
 * ClassName:GoodsBatchEntity <br/>
 * Function: 商品批次信息表. <br/>
 * Date:     2016年5月23日 上午11:10:47 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public class GoodsBatchEntity {

    public static final int StatusNotUse=1;//未使用
    public static final int StatusUsing=2;//正在使用
    public static final int StatusUsed=3;//已使用完
    public static final int StatusDeleted=4;//已经删除
    
    public static final int BatchTypeNormal=0;//普通券
    public static final int BatchTypeLink=1;//连接券
    public static final int BatchTypeRepeat=2;//重复券
    
    private Long id;
    
    private Integer gtype;
    
    private Long gid;
    
    private Integer batchType;//批次类型，比如：普通，链接，可重复
    
    private Date startDay;
    
    private Date endDay;
    
    private Integer status;
    
    private Boolean importing;
    
    private Long stockId;//关联库存中心的stockId
    
    private Date gmtCreate;
    
    private Date gmtModified;

    
    public Long getId() {
        return id;
    }

    
    public void setId(Long id) {
        this.id = id;
    }

    
    public Integer getGtype() {
        return gtype;
    }

    
    public void setGtype(Integer gtype) {
        this.gtype = gtype;
    }

    
    public Long getGid() {
        return gid;
    }

    
    public void setGid(Long gid) {
        this.gid = gid;
    }

    
    public Date getStartDay() {
        return startDay;
    }

    
    public void setStartDay(Date startDay) {
        this.startDay = startDay;
    }

    
    public Date getEndDay() {
        return endDay;
    }

    
    public void setEndDay(Date endDay) {
        this.endDay = endDay;
    }

    
    public Integer getStatus() {
        return status;
    }

    
    public void setStatus(Integer status) {
        this.status = status;
    }

    
    public Boolean getImporting() {
        return importing;
    }

    
    public void setImporting(Boolean importing) {
        this.importing = importing;
    }

    
    public Date getGmtCreate() {
        return gmtCreate;
    }

    
    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    
    public Date getGmtModified() {
        return gmtModified;
    }

    
    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }


    
    public Integer getBatchType() {
        return batchType;
    }


    
    public void setBatchType(Integer batchType) {
        this.batchType = batchType;
    }


    
    public Long getStockId() {
        return stockId;
    }


    
    public void setStockId(Long stockId) {
        this.stockId = stockId;
    }
    
    
}

