/**
 * Project Name:goods-center-biz
 * File Name:RemoteGoodsCouponServiceImpl.java
 * Package Name:cn.com.duiba.goods.center.biz.remoteservice.impl
 * Date:2016年5月24日下午4:21:53
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.remoteservice.impl;


import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsCouponDto;
import cn.com.duiba.goods.center.api.remoteservice.front.RemoteGoodsCouponService;
import cn.com.duiba.goods.center.biz.bo.GoodsCouponBO;
import cn.com.duiba.goods.center.biz.entity.GoodsCouponEntity;
import cn.com.duiba.goods.center.biz.util.PCGConvertUtil;
import cn.com.duiba.goods.center.common.RuntimeGoodsException;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;

/**
 * ClassName:RemoteGoodsCouponServiceImpl <br/>
 * Date:     2016年5月24日 下午4:21:53 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Service("remoteGoodsCouponService")
public class RemoteGoodsCouponServiceImpl implements RemoteGoodsCouponService{
    private static Logger log=LoggerFactory.getLogger(RemoteGoodsCouponServiceImpl.class);
    @Autowired
    private GoodsCouponBO goodsCouponBO;

    @Override
    public DubboResult<GoodsCouponDto> takeCoupon(GoodsTypeEnum gtype, long gid, long consumerId,String bizNum) {
        try{
            DBTimeProfile.enter("RemoteGoodsCouponServiceImpl.takeCoupon");
            GoodsCouponEntity coupon=goodsCouponBO.takeCoupon(gtype, gid, consumerId,bizNum);
            GoodsCouponDto dto=PCGConvertUtil.convert(coupon);
            return DubboResult.successResult(dto);
        }catch(RuntimeGoodsException rge){
            log.error("takeCoupon gtype="+gtype.getGtype()+",gid="+gid+",consumerId="+consumerId,rge);
            return DubboResult.failResult(rge.getResultMessage());
        }catch(Exception e){
            log.error("takeCoupon gtype="+gtype.getGtype()+",gid="+gid+",consumerId="+consumerId,e);
            return DubboResult.failResult(e.getMessage());
        }finally{
            DBTimeProfile.release();
        }
    }

    @Override
    public DubboResult<Boolean> completeCoupon(Long couponId, long orderId) {
        try{
            goodsCouponBO.completeCoupon(couponId, orderId);
            return DubboResult.successResult(true);
        }catch(Exception e){
            log.error("takeCoupon couponId="+couponId+",orderId="+orderId,e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> rollbackCoupon(Long couponId,String bizNum) {
        try{
            Boolean ret=goodsCouponBO.rollbackCoupon(couponId,bizNum);
            return DubboResult.successResult(ret);
        }catch(Exception e){
            log.error("rollbackCoupon couponId="+couponId,e);
            return DubboResult.failResult(e.getMessage());
        }
    }

}

