/**
 * Project Name:goods-center-biz
 * File Name:GoodsBatchService.java
 * Package Name:cn.com.duiba.goods.center.biz.service
 * Date:2016年5月25日下午12:21:02
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.service;

import java.util.Date;
import java.util.List;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.biz.entity.GoodsBatchEntity;

/**
 * ClassName:GoodsBatchService <br/>
 * Date:     2016年5月25日 下午12:21:02 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface GoodsBatchService {

    public Long createNormalBatch(GoodsTypeEnum gtype, long gid, Date start, Date end);

    public Long createLinkBatch(GoodsTypeEnum gtype, long gid, Date start, Date end);

    public Long createRepeatBatch(GoodsTypeEnum gtype, long gid, Date start, Date end);
    /**
     * 不包含已删除和已过期批次 
     *
     * @author xuhengfei
     * @param gtype
     * @param gid
     * @return
     * @since JDK 1.6
     */
    public List<GoodsBatchEntity> findNormalBatchs(GoodsTypeEnum gtype, long gid);
    /**
     * 不包含已删除的批次 
     *
     * @author xuhengfei
     * @param gtype
     * @param gid
     * @return
     * @since JDK 1.6
     */
    public List<GoodsBatchEntity> findNotDeletedBatchs(GoodsTypeEnum gtype,long gid);

    public Boolean deleteBatch(GoodsTypeEnum gtype, long gid, Long batchId);
    
    public Boolean fillStockId(GoodsTypeEnum gtype, long gid,long goodsBatchId,long stockId);
    
    public GoodsBatchEntity find(Long goodsBatchId);
    /**
     * 获取商品的所有批次的剩余库存
     *
     * @author xuhengfei
     * @param gtype
     * @param gid
     * @param goodsBatchId
     * @return
     * @since JDK 1.6
     */
    public Long getSumBatchStock(GoodsTypeEnum gtype,long gid);
    /**
     * 获取商品的总库存(包含已经消耗的库存)
     *
     * @author xuhengfei
     * @param gtype
     * @param gid
     * @return
     * @since JDK 1.6
     */
    public Long getTotalAllBatchStock(GoodsTypeEnum gtype,long gid);
    
    /**
     * 刷新批次
     * 当前批次如果已经售罄，标记当前批次已使用，切换到下一个批次
     *
     * @author xuhengfei
     * @param gtype
     * @param gid
     * @since JDK 1.6
     
    public void refreshBatchUsing(GoodsTypeEnum gtype,long gid);
    */
    
    /**
     * 获取正在使用中的批次<br/>
     * 直接根据数据库中的状态来判断，不校验库存等信息
     *
     * @author xuhengfei
     * @param gtype
     * @param gid
     * @return
     * @since JDK 1.6
     */
    public GoodsBatchEntity getUsingBatch(GoodsTypeEnum gtype,long gid);
    
    /**
     * 将批次标记为已经售罄<br/>
     * 由于批次只记录信息，不记录库存。当库存没有时，需要外部来设置售罄状态<br/>
     *
     * @author xuhengfei
     * @param batchId
     * @since JDK 1.6
     */
    public void markBatchStatusUsed(long batchId);
    /**
     * 将批次标记为正在使用中<br/>
     * 由于批次只记录信息，不记录库存。当需要切换批次时，需要外部来设置售罄状态<br/>
     *
     * @author xuhengfei
     * @param batchId
     * @since JDK 1.6
     */
    public void markBatchStatusUsing(long batchId);
    /**
     * 将批次标记为未使用<br/>
     * 由于批次只记录信息，不记录库存。当批次被再次导入券码时，需要外部设置为未使用，以便后续使用<br/>
     * markBatchStatusNotUsed:(这里用一句话描述这个方法的作用). <br/>
     * TODO(这里描述这个方法适用条件 – 可选).<br/>
     * TODO(这里描述这个方法的执行流程 – 可选).<br/>
     * TODO(这里描述这个方法的使用方法 – 可选).<br/>
     * TODO(这里描述这个方法的注意事项 – 可选).<br/>
     *
     * @author xuhengfei
     * @param batchId
     * @since JDK 1.6
     */
    public void markBatchStatusNotUsed(long batchId);
}

