/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.bo.impl;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsDirectionalConfigDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGCategorySellerGoodsDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGFilterConfigDto;
import cn.com.duiba.goods.center.api.remoteservice.tool.Page;
import cn.com.duiba.goods.center.biz.bo.GoodsBatchCouponBackendBO;
import cn.com.duiba.goods.center.biz.bo.PCGFilterConfigBO;
import cn.com.duiba.goods.center.biz.entity.GoodsDirectionalConfigEntity;
import cn.com.duiba.goods.center.biz.entity.PCGCategoryEntity;
import cn.com.duiba.goods.center.biz.entity.PCGCategoryGoodsEntity;
import cn.com.duiba.goods.center.biz.entity.PCGSellerEntity;
import cn.com.duiba.goods.center.biz.entity.PCGSellerGoodsEntity;
import cn.com.duiba.goods.center.biz.entity.PlatformCouponGoodsEntity;
import cn.com.duiba.goods.center.biz.service.GoodsBatchService;
import cn.com.duiba.goods.center.biz.service.GoodsDirectionalConfigService;
import cn.com.duiba.goods.center.biz.service.GoodsLimitRecordService;
import cn.com.duiba.goods.center.biz.service.PCGCategoryGoodsService;
import cn.com.duiba.goods.center.biz.service.PCGFilterConfigService;
import cn.com.duiba.goods.center.biz.service.PCGSellerGoodsService;
import cn.com.duiba.goods.center.biz.service.PlatformCouponGoodsService;
import cn.com.duiba.service.remoteservice.RemoteAppService;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockBackendService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.ObjectUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PCGFilterConfigBOImpl
implements PCGFilterConfigBO {
    @Autowired
    private PCGFilterConfigService pCGFilterConfigService;
    @Autowired
    private PCGCategoryGoodsService pCGCategoryGoodsService;
    @Autowired
    private PCGSellerGoodsService pCGSellerGoodsService;
    @Autowired
    private GoodsDirectionalConfigService goodsDirectionalConfigService;
    @Autowired
    private PlatformCouponGoodsService platformCouponGoodsService;
    @Autowired
    protected GoodsBatchService goodsBatchService;
    @Autowired
    protected RemoteAppService remoteAppService;
    @Autowired
    protected RemoteStockBackendService remoteStockBackendService;
    @Autowired
    protected GoodsLimitRecordService goodsLimitRecordService;
    @Autowired
    protected GoodsBatchCouponBackendBO goodsBatchCouponBackendBO;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd");
    private SimpleDateFormat sdf2 = new SimpleDateFormat("yyyyMMdd");

    public List<Long> filterGoods(List<Long> pcgIds, Long appId) {
        List<Long> filterGoodsIds = this.pCGFilterConfigService.selectPCGFilterTargetIds(appId, 1);
        if (!filterGoodsIds.isEmpty()) {
            Iterator<Long> ps = pcgIds.iterator();
            while (ps.hasNext()) {
                Long pcgId = ps.next();
                for (Long filterGoodsId : filterGoodsIds) {
                    if (pcgId - filterGoodsId != 0L) continue;
                    ps.remove();
                }
            }
        }
        return pcgIds;
    }

    @Override
    public Page<PCGCategorySellerGoodsDto> findCategoryGoods(long appId, long categoryId, Long consumerId, Long consumerCredits, Integer pageIndex, Integer pageSize) {
        List<Long> pcgIds = new ArrayList<Long>();
        List<PCGCategoryGoodsEntity> pCGCategoryGoodsEntity = this.pCGCategoryGoodsService.findAllGoodsByCategory(categoryId);
        ArrayList<PCGIdAndPayLoad> pCGIdAndPayLoads = new ArrayList<PCGIdAndPayLoad>();
        for (PCGCategoryGoodsEntity cateGoods : pCGCategoryGoodsEntity) {
            pcgIds.add(cateGoods.getPcgId());
            pCGIdAndPayLoads.add(new PCGIdAndPayLoad(cateGoods.getPcgId(), cateGoods.getPayload()));
        }
        pcgIds = this.checkBlack(pcgIds, appId);
        Page<PCGCategorySellerGoodsDto> page = new Page<PCGCategorySellerGoodsDto>(pageSize.intValue(), pageIndex.intValue());
        if (pcgIds != null && !pcgIds.isEmpty()) {
            page = this.findGoods(appId, pcgIds, consumerId, consumerCredits, pCGIdAndPayLoads, pageIndex, pageSize);
        }
        return page;
    }

    public static Integer setPayLoad(List<PCGIdAndPayLoad> ppl, Long pcgId) {
        for (PCGIdAndPayLoad p : ppl) {
            if (p.getPagId().longValue() != pcgId.longValue()) continue;
            return p.getPayLoad();
        }
        return 0;
    }

    public Page<PCGCategorySellerGoodsDto> findGoods(Long appId, List<Long> pcgIds, Long consumerId, Long consumerCredits, List<PCGIdAndPayLoad> pCGIdAndPayLoads, Integer pageIndex, Integer pageSize) {
        ArrayList<PCGCategorySellerGoodsDto> goodsList = new ArrayList<PCGCategorySellerGoodsDto>();
        Map<String, GoodsDirectionalConfigEntity> directionals = this.goodsDirectionalConfigService.findByGoodsAll(GoodsTypeEnum.PLATFORM, pcgIds);
        Map<Long, PlatformCouponGoodsEntity> pcgs = this.platformCouponGoodsService.findByIds(pcgIds);
        for (Long pcgIdKey : pcgs.keySet()) {
            DubboResult result;
            GoodsDirectionalConfigEntity gdce1 = null;
            GoodsDirectionalConfigEntity gdce2 = null;
            PlatformCouponGoodsEntity pce = pcgs.get(pcgIdKey);
            if (1 != pce.getPcgStatus() || pce.getDeleted().booleanValue()) continue;
            if (PCGFilterConfigBOImpl.isOpen(1, pce.getSwitches().intValue()) && !directionals.isEmpty()) {
                gdce1 = directionals.get(appId + "-" + pcgIdKey);
                gdce2 = directionals.get("0-" + pcgIdKey);
                if (gdce1 == null && gdce2 == null) continue;
            }
            PCGCategorySellerGoodsDto psgd = new PCGCategorySellerGoodsDto();
            ObjectUtil.convert((Object)pce, (Object)psgd);
            GoodsDirectionalConfigDto gc = new GoodsDirectionalConfigDto();
            if (gdce2 != null) {
                ObjectUtil.convert(gdce2, (Object)gc);
                if (gdce2.getStockId() == null) {
                    gc.setStock(Long.valueOf(0L));
                } else {
                    result = this.remoteStockBackendService.find(gdce2.getStockId().longValue());
                    if (result != null && result.isSuccess() && result.getResult() != null) {
                        gc.setStock((Long)result.getResult());
                    }
                }
            }
            if (gdce1 != null) {
                gc = new GoodsDirectionalConfigDto();
                ObjectUtil.convert((Object)gdce1, (Object)gc);
                if (gdce1.getStockId() == null) {
                    gc.setStock(Long.valueOf(0L));
                } else {
                    result = this.remoteStockBackendService.find(gdce1.getStockId().longValue());
                    if (result != null && result.isSuccess() && result.getResult() != null) {
                        gc.setStock((Long)result.getResult());
                    }
                }
            }
            psgd.setGoodsDirectionalConfigDto(gc);
            psgd.setPayLoad(PCGFilterConfigBOImpl.setPayLoad(pCGIdAndPayLoads, psgd.getPcgId()));
            long pcgStock = this.goodsBatchService.getSumBatchStock(GoodsTypeEnum.PLATFORM, pce.getPcgId());
            psgd.setStock(Long.valueOf(pcgStock));
            goodsList.add(psgd);
        }
        return this.page(pageIndex, pageSize, goodsList);
    }

    @Override
    public Page<PCGCategorySellerGoodsDto> findSellerGoods(long appId, long sellerId, Long consumerId, Long consumerCredits, Integer pageIndex, Integer pageSize) {
        List<Long> pcgIds = new ArrayList<Long>();
        ArrayList<PCGIdAndPayLoad> pCGIdAndPayLoads = new ArrayList<PCGIdAndPayLoad>();
        List<PCGSellerGoodsEntity> pCGSellerGoodsEntity = this.pCGSellerGoodsService.findAllGoodsBySeller(sellerId);
        for (PCGSellerGoodsEntity cateGoods : pCGSellerGoodsEntity) {
            pcgIds.add(cateGoods.getPcgId());
            pCGIdAndPayLoads.add(new PCGIdAndPayLoad(cateGoods.getPcgId(), cateGoods.getPayload()));
        }
        pcgIds = this.checkBlack(pcgIds, appId);
        Page<PCGCategorySellerGoodsDto> page = new Page<PCGCategorySellerGoodsDto>(pageSize.intValue(), pageIndex.intValue());
        if (!pcgIds.isEmpty()) {
            page = this.findGoods(appId, pcgIds, consumerId, consumerCredits, pCGIdAndPayLoads, pageIndex, pageSize);
        }
        return page;
    }

    @Override
    public List<Long> checkBlack(List<Long> pcgIds, Long appId) {
        List<PCGCategoryEntity> cates = this.pCGFilterConfigService.findCategoryFilterList(appId);
        HashSet<Long> catSet = new HashSet<Long>();
        for (PCGCategoryEntity c : cates) {
            catSet.add(c.getId());
        }
        List<PCGSellerEntity> sellers = this.pCGFilterConfigService.findSellerFilterList(appId);
        HashSet<Long> sellerSet = new HashSet<Long>();
        for (PCGSellerEntity e : sellers) {
            sellerSet.add(e.getId());
        }
        Map<Long, List<PCGFilterConfigDto>> belongs = this.pCGFilterConfigService.findFilterCounponBelongs(catSet, sellerSet);
        List<PlatformCouponGoodsEntity> goodss = this.pCGFilterConfigService.findGoodsFilterList(appId);
        boolean flag = true;
        Iterator<Long> ps = pcgIds.iterator();
        block2: while (ps.hasNext()) {
            flag = true;
            long pcgId = ps.next();
            for (PlatformCouponGoodsEntity goods : goodss) {
                if (pcgId - goods.getPcgId() != 0L) continue;
                ps.remove();
                flag = false;
                break;
            }
            if (belongs == null || belongs.isEmpty()) continue;
            List<PCGFilterConfigDto> pcs = belongs.get(pcgId);
            if (!flag || pcs == null || pcs.isEmpty()) continue;
            for (PCGFilterConfigDto f : belongs.get(pcgId)) {
                if (f.getType() == 2) {
                    if (!catSet.contains(f.getTargetId())) continue;
                    ps.remove();
                    continue block2;
                }
                if (f.getType() != 3 || !sellerSet.contains(f.getTargetId())) continue;
                ps.remove();
                continue block2;
            }
        }
        return pcgIds;
    }

    public static boolean isOpen(int bit, int switches) {
        int v = 1 << bit;
        int ret = switches & v;
        return ret != 0;
    }

    public <T extends Comparable<? super T>> Page<T> page(Integer pageIndex, Integer pageSize, List<T> t) {
        int totalPages;
        Page page = new Page(pageSize.intValue(), pageIndex.intValue());
        ArrayList<T> newList = new ArrayList<T>();
        page.setList(newList);
        if (t.isEmpty()) {
            return page;
        }
        Collections.sort(t);
        int total = t.size();
        int index = 0;
        if (pageIndex > 1) {
            index = (pageIndex - 1) * pageSize;
        }
        int n = totalPages = total % pageSize == 0 ? total / pageSize : total / pageSize + 1;
        if (pageIndex <= totalPages) {
            if (pageIndex == 1) {
                pageIndex = 0;
            }
            for (int i = index; i < total && pageSize * (pageIndex + 1) != i; ++i) {
                newList.add(t.get(i));
            }
        }
        page.setList(newList);
        page.setTotalPages(totalPages);
        page.setPageSize(pageSize.intValue());
        page.setCurrent(pageIndex.intValue());
        return page;
    }

    public static class PCGIdAndPayLoad {
        private Long pagId;
        private Integer payLoad;

        public PCGIdAndPayLoad() {
        }

        public PCGIdAndPayLoad(Long pcgId, Integer payLoad) {
            this.pagId = pcgId;
            this.payLoad = payLoad;
        }

        public Long getPagId() {
            return this.pagId;
        }

        public Integer getPayLoad() {
            return this.payLoad;
        }
    }
}

