/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.remoteservice.impl;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.RemoteAdvertCouponGoodsBackendService;
import cn.com.duiba.goods.center.api.remoteservice.RemoteGoodsCouponBackendService;
import cn.com.duiba.goods.center.api.remoteservice.dto.AdvertCouponGoodsDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.ChangeACGTypeDto;
import cn.com.duiba.goods.center.biz.entity.GoodsContentEntity;
import cn.com.duiba.goods.center.biz.service.AdvertCouponGoodsService;
import cn.com.duiba.goods.center.biz.service.GoodsBatchService;
import cn.com.duiba.goods.center.biz.service.GoodsContentService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="remoteAdvertCouponGoodsBackendService")
public class RemoteAdvertCouponGoodsBackendServiceImpl
implements RemoteAdvertCouponGoodsBackendService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteAdvertCouponGoodsBackendServiceImpl.class);
    @Autowired
    private AdvertCouponGoodsService advertCouponGoodsService;
    @Autowired
    private GoodsContentService goodsContentService;
    @Autowired
    private GoodsBatchService goodsBatchService;
    @Autowired
    private RemoteGoodsCouponBackendService remoteGoodsCouponBackendService;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;

    public DubboResult<Boolean> createAdvertCouponGoods(AdvertCouponGoodsDto goods) {
        try {
            if (this.advertCouponGoodsService.insert(goods)) {
                this.goodsContentService.add(GoodsTypeEnum.ADVERT, goods.getAcgId(), goods.getCouponRemark(), goods.getExchangeTips());
            }
            return DubboResult.successResult((Object)true);
        }
        catch (Exception e) {
            LOGGER.error("createAdvertCouponGoods failed, the req=[{}]", (Object)goods, (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> editAdvertCouponGoods(Long acgId, AdvertCouponGoodsDto goods) {
        try {
            if (this.advertCouponGoodsService.update(goods)) {
                this.goodsContentService.update(GoodsTypeEnum.ADVERT, goods.getAcgId(), goods.getCouponRemark(), goods.getExchangeTips());
            }
            return DubboResult.successResult((Object)true);
        }
        catch (Exception e) {
            LOGGER.error("editAdvertCouponGoods failed, the req=[{}]", (Object)goods, (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> deleteGoods(Long acgId) {
        try {
            return DubboResult.successResult((Object)this.advertCouponGoodsService.delete(acgId));
        }
        catch (Exception e) {
            LOGGER.error("deleteGoods failed, the req=[{}]", (Object)acgId, (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<AdvertCouponGoodsDto> find(Long acgId) {
        try {
            AdvertCouponGoodsDto couponGoods = this.advertCouponGoodsService.select(acgId);
            GoodsContentEntity content = this.goodsContentService.findByGoods(GoodsTypeEnum.ADVERT, acgId);
            if (content != null) {
                couponGoods.setCouponRemark(content.getContent());
                couponGoods.setExchangeTips(content.getExchangeTips());
            }
            return DubboResult.successResult((Object)couponGoods);
        }
        catch (Exception e) {
            LOGGER.error("find failed, the req=[{}]", (Object)acgId, (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> changeACGType(ChangeACGTypeDto changeACGTypeDto) {
        try {
            DubboResult createNormalBatchResult;
            GoodsTypeEnum gtype = changeACGTypeDto.getGtype();
            long gid = changeACGTypeDto.getAcgId();
            long batchId = changeACGTypeDto.getBatchId();
            int dstType = changeACGTypeDto.getDstType();
            Date start = changeACGTypeDto.getStart();
            Date end = changeACGTypeDto.getEnd();
            DubboResult deleteGoodsCouponResult = this.remoteGoodsCouponBackendService.deleteGoodsCoupon(gtype, gid, batchId);
            if (!deleteGoodsCouponResult.isSuccess()) {
                LOGGER.error("remoteGoodsCouponBackendService deleteGoodsCoupon failed");
                return DubboResult.failResult((String)"remoteGoodsCouponBackendService deleteGoodsCoupon failed");
            }
            DubboResult dubboResult = this.remoteGoodsCouponBackendService.physicalDeleteBatch(gtype, gid, Long.valueOf(batchId));
            if (!dubboResult.isSuccess() || !((Boolean)dubboResult.getResult()).booleanValue()) {
                LOGGER.error("remoteGoodsCouponBackendService deleteBatch failed");
                return DubboResult.failResult((String)"remoteGoodsCouponBackendService deleteBatch failed");
            }
            try {
                this.redisTemplate.delete((Object)("goods-RedisBatchCache-" + gtype.getGtype() + "-" + gid));
            }
            catch (Exception e) {
                LOGGER.error("RedisBatchCache.clearBatchsCache gtype=" + gtype.getGtype() + ",gid=" + gid, (Throwable)e);
            }
            if (!(ChangeACGTypeDto.NORMAL_TYPE != dstType || (createNormalBatchResult = this.remoteGoodsCouponBackendService.createNormalBatch(gtype, gid, start, end)).isSuccess() && createNormalBatchResult.getResult() != null)) {
                LOGGER.error("remoteGoodsCouponBackendService createNormalBatch failed");
                return DubboResult.failResult((String)"remoteGoodsCouponBackendService createNormalBatch failed");
            }
            if (!(ChangeACGTypeDto.LINK_TYPE != dstType || (createNormalBatchResult = this.remoteGoodsCouponBackendService.createLinkBatch(gtype, gid, start, end, changeACGTypeDto.getLink(), changeACGTypeDto.getStock())).isSuccess() && createNormalBatchResult.getResult() != null)) {
                LOGGER.error("remoteGoodsCouponBackendService createNormalBatch failed");
                return DubboResult.failResult((String)"remoteGoodsCouponBackendService createNormalBatch failed");
            }
            if (!(ChangeACGTypeDto.REPEAT_TYPE != dstType || (createNormalBatchResult = this.remoteGoodsCouponBackendService.createRepeatBatch(gtype, gid, start, end, changeACGTypeDto.getCode(), changeACGTypeDto.getPassword(), changeACGTypeDto.getStock())).isSuccess() && createNormalBatchResult.getResult() != null)) {
                LOGGER.error("remoteGoodsCouponBackendService createRepeatBatch failed");
                return DubboResult.failResult((String)"remoteGoodsCouponBackendService createRepeatBatch failed");
            }
            return DubboResult.successResult((Object)true);
        }
        catch (Exception e) {
            LOGGER.error("changeACGType failed the message=[{}]", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }
}

