/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.remoteservice.impl;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsBatchDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsCouponDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsStockDto;
import cn.com.duiba.goods.center.api.remoteservice.front.RemoteGoodsCouponService;
import cn.com.duiba.goods.center.biz.bo.GoodsCouponBO;
import cn.com.duiba.goods.center.biz.entity.GoodsBatchEntity;
import cn.com.duiba.goods.center.biz.entity.GoodsCouponEntity;
import cn.com.duiba.goods.center.biz.service.GoodsBatchService;
import cn.com.duiba.goods.center.biz.service.GoodsCouponService;
import cn.com.duiba.goods.center.biz.util.PCGConvertUtil;
import cn.com.duiba.goods.center.common.RuntimeGoodsException;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="remoteGoodsCouponService")
public class RemoteGoodsCouponServiceImpl
implements RemoteGoodsCouponService {
    private static Logger log = LoggerFactory.getLogger(RemoteGoodsCouponServiceImpl.class);
    @Autowired
    private GoodsCouponBO goodsCouponBO;
    @Autowired
    private GoodsCouponService goodsCouponService;
    @Autowired
    private GoodsBatchService goodsBatchService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DubboResult<GoodsCouponDto> takeCoupon(GoodsTypeEnum gtype, long gid, long consumerId, String bizNum) {
        try {
            DBTimeProfile.enter((String)"RemoteGoodsCouponServiceImpl.takeCoupon");
            GoodsCouponEntity coupon = this.goodsCouponBO.takeCoupon(gtype, gid, consumerId, bizNum);
            if (coupon == null) {
                DubboResult dubboResult = DubboResult.successResult(null);
                return dubboResult;
            }
            GoodsCouponDto dto = PCGConvertUtil.convert(coupon);
            GoodsBatchEntity batch = this.goodsBatchService.find(coupon.getGoodsBatchId());
            dto.setOverDue(batch.getEndDay());
            DubboResult dubboResult = DubboResult.successResult((Object)dto);
            return dubboResult;
        }
        catch (RuntimeGoodsException rge) {
            log.error("takeCoupon gtype=" + gtype.getGtype() + ",gid=" + gid + ",consumerId=" + consumerId, (Throwable)rge);
            DubboResult dubboResult = DubboResult.failResult((String)rge.getResultMessage());
            return dubboResult;
        }
        catch (Exception e) {
            log.error("takeCoupon gtype=" + gtype.getGtype() + ",gid=" + gid + ",consumerId=" + consumerId, (Throwable)e);
            DubboResult dubboResult = DubboResult.failResult((String)e.getMessage());
            return dubboResult;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    public DubboResult<Boolean> completeCoupon(Long couponId, long orderId) {
        try {
            this.goodsCouponBO.completeCoupon(couponId, orderId);
            return DubboResult.successResult((Object)true);
        }
        catch (Exception e) {
            log.error("takeCoupon couponId=" + couponId + ",orderId=" + orderId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> rollbackCoupon(Long couponId, String bizNum) {
        try {
            Boolean ret = this.goodsCouponBO.rollbackCoupon(couponId, bizNum);
            return DubboResult.successResult((Object)ret);
        }
        catch (Exception e) {
            log.error("rollbackCoupon couponId=" + couponId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<GoodsCouponDto> findCoupon(GoodsTypeEnum gtype, long gid, Long couponId) {
        try {
            GoodsCouponEntity coupon = this.goodsCouponBO.findCoupon(couponId);
            GoodsBatchEntity batch = this.goodsCouponBO.findBatch(coupon.getGoodsBatchId());
            GoodsCouponDto dto = PCGConvertUtil.convert(coupon);
            dto.setStartDay(batch.getStartDay());
            dto.setOverDue(batch.getEndDay());
            return DubboResult.successResult((Object)dto);
        }
        catch (Exception e) {
            log.error("findCoupon gtype=" + gtype.getGtype() + ",gid=" + gid + ",couponId=" + couponId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Long> findGoodsStock(GoodsTypeEnum gtype, long gid) {
        try {
            long stock = this.goodsCouponBO.findGoodsStock(gtype, gid);
            return DubboResult.successResult((Object)stock);
        }
        catch (Exception e) {
            log.error("findCurrentBacthStock gtype=" + gtype.getGtype() + ",gid=" + gid, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<GoodsStockDto>> findGoodsStockByBatch(List<GoodsStockDto> goods) {
        try {
            List<GoodsStockDto> dtos = this.goodsCouponBO.findGoodsStockByBatch(goods);
            return DubboResult.successResult(dtos);
        }
        catch (Exception e) {
            log.error("findCurrentBatchStockByBatch", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<GoodsBatchDto> findUsingBatch(GoodsTypeEnum gtype, long gid) {
        try {
            GoodsBatchEntity batch = this.goodsCouponBO.findUsingBatch(gtype, gid);
            if (batch != null) {
                GoodsBatchDto dto = PCGConvertUtil.convert(batch);
                return DubboResult.successResult((Object)dto);
            }
            return DubboResult.failResult((String)"\u6ca1\u6709\u4f7f\u7528\u4e2d\u7684\u6279\u6b21");
        }
        catch (Exception e) {
            log.error("findUsingBatch gtype=" + gtype.getGtype() + ",gid=" + gid, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public GoodsCouponDto findCoupon(long couponId) {
        GoodsCouponEntity coupon = this.goodsCouponService.find(couponId);
        long batchId = coupon.getGoodsBatchId();
        GoodsBatchEntity batch = this.goodsBatchService.find(batchId);
        GoodsCouponDto dto = PCGConvertUtil.convert(coupon);
        dto.setOverDue(batch.getEndDay());
        return dto;
    }
}

