/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.remoteservice.impl;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.RemotePlatformCouponGoodsBackendService;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGEditDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGInsertDto;
import cn.com.duiba.goods.center.api.remoteservice.tool.Page;
import cn.com.duiba.goods.center.biz.entity.GoodsContentEntity;
import cn.com.duiba.goods.center.biz.entity.PlatformCouponGoodsEntity;
import cn.com.duiba.goods.center.biz.service.GoodsBatchService;
import cn.com.duiba.goods.center.biz.service.GoodsCenterConfigService;
import cn.com.duiba.goods.center.biz.service.GoodsContentService;
import cn.com.duiba.goods.center.biz.service.PlatformCouponGoodsService;
import cn.com.duiba.goods.center.biz.util.PCGConvertUtil;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="remotePlatformCouponGoodsBackendService")
public class RemotePlatformCouponGoodsBackendServiceImpl
implements RemotePlatformCouponGoodsBackendService {
    private static Logger log = LoggerFactory.getLogger(RemotePlatformCouponGoodsBackendServiceImpl.class);
    @Autowired
    private PlatformCouponGoodsService platformCouponGoodsService;
    @Autowired
    private GoodsContentService goodsContentService;
    @Autowired
    private GoodsBatchService goodsBatchService;
    @Autowired
    private GoodsCenterConfigService goodsCenterConfigService;

    public DubboResult<Boolean> editHomeImages(String logoImage, String bannerImage) {
        try {
            this.goodsCenterConfigService.updateHomeImages(logoImage, bannerImage);
            return DubboResult.successResult((Object)true);
        }
        catch (Exception e) {
            log.error("editHomeImages logoImage=" + logoImage + ",bannerImage=" + bannerImage, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<String>> getHomeImages() {
        try {
            List<String> ret = this.goodsCenterConfigService.findHomeImages();
            return DubboResult.successResult(ret);
        }
        catch (Exception e) {
            log.error("getHomeImages ", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<PCGDto> find(long pcgId) {
        try {
            PlatformCouponGoodsEntity e = this.platformCouponGoodsService.findIncludeDeleted(pcgId);
            if (e == null) {
                return DubboResult.failResult((String)"\u5546\u54c1\u4e0d\u5b58\u5728");
            }
            if (e.getDeleted().booleanValue()) {
                return DubboResult.failResult((String)"\u5546\u54c1\u88ab\u505c\u7528");
            }
            PCGDto dto = PCGConvertUtil.convert(e);
            GoodsContentEntity c = this.goodsContentService.findByGoods(GoodsTypeEnum.PLATFORM, pcgId);
            long stock = this.goodsBatchService.getSumBatchStock(GoodsTypeEnum.PLATFORM, e.getPcgId());
            dto.setStock(Long.valueOf(stock));
            dto.setTotalStock(this.goodsBatchService.getTotalAllBatchStock(GoodsTypeEnum.PLATFORM, e.getPcgId()));
            dto.setDetail(c.getContent());
            return DubboResult.successResult((Object)dto);
        }
        catch (Exception e) {
            log.error("find pcgId=" + pcgId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Long> createPlatformCouponGoods(PCGInsertDto goods) {
        try {
            Long pcgId = this.platformCouponGoodsService.createPlatformCouponGoods(goods);
            if (pcgId != null) {
                this.goodsContentService.addContent(GoodsTypeEnum.PLATFORM, pcgId, goods.getDetail());
                return DubboResult.successResult((Object)pcgId);
            }
            return DubboResult.failResult((String)"\u521b\u5efa\u5931\u8d25");
        }
        catch (Exception e) {
            log.error("createPlatformCouponGoods error", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> editPlatformCouponGoods(Long pcgId, PCGEditDto goods) {
        try {
            this.platformCouponGoodsService.editPlatformCouponGoods(pcgId, goods);
            if (goods.getDetail() != null) {
                this.goodsContentService.updateContent(GoodsTypeEnum.PLATFORM, pcgId, goods.getDetail());
            }
            return DubboResult.successResult((Object)true);
        }
        catch (Exception e) {
            log.error("editPlatformCouponGoods error,pcgId=" + pcgId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> onshelfGoods(Long pcgId) {
        try {
            this.platformCouponGoodsService.onshelfGoods(pcgId);
            return DubboResult.successResult((Object)true);
        }
        catch (Exception e) {
            log.error("onshelfGoods error,pcgId=" + pcgId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> offshelfGoods(Long pcgId) {
        try {
            this.platformCouponGoodsService.offshelfGoods(pcgId);
            return DubboResult.successResult((Object)true);
        }
        catch (Exception e) {
            log.error("offshelfGoods error,pcgId=" + pcgId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> deleteGoods(Long pcgId) {
        try {
            this.platformCouponGoodsService.deleteGoods(pcgId);
            return DubboResult.successResult((Object)true);
        }
        catch (Exception e) {
            log.error("deleteGoods error,pcgId=" + pcgId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<PCGDto>> searchByName(String name) {
        try {
            List<PlatformCouponGoodsEntity> list = this.platformCouponGoodsService.searchByName(name);
            ArrayList<PCGDto> ret = new ArrayList<PCGDto>();
            for (PlatformCouponGoodsEntity e : list) {
                ret.add(PCGConvertUtil.convert(e));
            }
            return DubboResult.successResult(ret);
        }
        catch (Exception e) {
            log.error("searchByName name=" + name, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public Page<PCGDto> findPage(String name, Integer pcgStatus, int pageSize, int pageIndex) {
        Page ret = new Page(pageSize, pageIndex);
        Page<PlatformCouponGoodsEntity> page = this.platformCouponGoodsService.findPage(name, pcgStatus, pageSize, pageIndex);
        ret.setTotalCount(page.getTotalCount());
        ret.setTotalPages(page.getTotalPages());
        ArrayList<PCGDto> pageList = new ArrayList<PCGDto>();
        for (PlatformCouponGoodsEntity e : page.getList()) {
            PCGDto dto = PCGConvertUtil.convert(e);
            long stock = this.goodsBatchService.getSumBatchStock(GoodsTypeEnum.PLATFORM, e.getPcgId());
            dto.setStock(Long.valueOf(stock));
            dto.setTotalStock(this.goodsBatchService.getTotalAllBatchStock(GoodsTypeEnum.PLATFORM, e.getPcgId()));
            pageList.add(dto);
        }
        ret.setList(pageList);
        return ret;
    }

    public DubboResult<Boolean> editSwitches(Long pcgId, Integer bit, Boolean open) {
        try {
            if (pcgId == null || bit == null || open == null) {
                return DubboResult.failResult((String)"\u53c2\u6570\u4e0d\u5f97\u4e3a\u7a7a\uff01");
            }
            PlatformCouponGoodsEntity entity = this.platformCouponGoodsService.find(pcgId);
            long switches = entity.getSwitches();
            if (open.booleanValue()) {
                int v = 1 << bit;
                switches |= (long)v;
            } else {
                int v = 1 << bit;
                switches &= (long)(v ^= 0xFFFFFFFF);
            }
            this.platformCouponGoodsService.editPCGSwitches(pcgId, switches);
            return DubboResult.successResult((Object)true);
        }
        catch (Exception e) {
            log.error("editSwitches(" + pcgId + "," + bit + "," + open + ") invoke error\n", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }
}

