package cn.com.duiba.goods.center.biz.bo.impl;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.constant.PlatformCouponGoodsConstant;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsBatchDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsDirectionalConfigDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGCategorySellerGoodsDto;
import cn.com.duiba.goods.center.api.remoteservice.tool.Page;
import cn.com.duiba.goods.center.biz.bo.GoodsBatchCouponBackendBO;
import cn.com.duiba.goods.center.biz.bo.PCGFilterConfigBO;
import cn.com.duiba.goods.center.biz.entity.GoodsDirectionalConfigEntity;
import cn.com.duiba.goods.center.biz.entity.PCGCategoryEntity;
import cn.com.duiba.goods.center.biz.entity.PCGCategoryGoodsEntity;
import cn.com.duiba.goods.center.biz.entity.PCGSellerEntity;
import cn.com.duiba.goods.center.biz.entity.PCGSellerGoodsEntity;
import cn.com.duiba.goods.center.biz.entity.PlatformCouponGoodsEntity;
import cn.com.duiba.goods.center.biz.service.GoodsBatchService;
import cn.com.duiba.goods.center.biz.service.GoodsDirectionalConfigService;
import cn.com.duiba.goods.center.biz.service.GoodsLimitRecordService;
import cn.com.duiba.goods.center.biz.service.PCGCategoryGoodsService;
import cn.com.duiba.goods.center.biz.service.PCGFilterConfigService;
import cn.com.duiba.goods.center.biz.service.PCGSellerGoodsService;
import cn.com.duiba.goods.center.biz.service.PlatformCouponGoodsService;
import cn.com.duiba.service.remoteservice.RemoteAppService;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockBackendService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.ObjectUtil;

import com.alibaba.dubbo.common.utils.StringUtils;
@Service
public class PCGFilterConfigBOImpl implements PCGFilterConfigBO{
    public static class PCGIdAndPayLoad{
        public PCGIdAndPayLoad(){
            
        }
        public PCGIdAndPayLoad(Long pcgId,Integer payLoad){
            this.pagId = pcgId;
            this.payLoad = payLoad;
        }
        private Long pagId;
        private Integer payLoad;
        public Long getPagId() {
            return pagId;
        }
        public Integer getPayLoad() {
            return payLoad;
        }
        
        
    }

    @Autowired
    private PCGFilterConfigService        pCGFilterConfigService;
    @Autowired
    private PCGCategoryGoodsService       pCGCategoryGoodsService;
    @Autowired
    private PCGSellerGoodsService         pCGSellerGoodsService;
    @Autowired
    private GoodsDirectionalConfigService goodsDirectionalConfigService;
    @Autowired
    private PlatformCouponGoodsService    platformCouponGoodsService;
    @Autowired
    protected GoodsBatchService           goodsBatchService;
    @Autowired
    protected RemoteAppService            remoteAppService;
    @Autowired
    protected RemoteStockBackendService   remoteStockBackendService;
    @Autowired
    protected GoodsLimitRecordService     goodsLimitRecordService;
    @Autowired
    protected GoodsBatchCouponBackendBO   goodsBatchCouponBackendBO;
    private SimpleDateFormat              sdf  = new SimpleDateFormat("yyyy.MM.dd");
    private SimpleDateFormat              sdf2 = new SimpleDateFormat("yyyyMMdd");

    public List<Long> filterGoods(List<Long> pcgIds, Long appId) {
        List<Long> filterGoodsIds = pCGFilterConfigService.selectPCGFilterTargetIds(appId,
                                                                                    PlatformCouponGoodsConstant.PcgFilterConfigGoodsType);
        if (!filterGoodsIds.isEmpty()) {
            Iterator<Long> ps = pcgIds.iterator();
            while (ps.hasNext()) {
                Long pcgId = ps.next();
                for (Long filterGoodsId : filterGoodsIds) {
                    // 当前商品被屏蔽，清除
                    if ((pcgId - filterGoodsId) == 0) {
                        ps.remove();
                    }
                }
            }
        }
        return pcgIds;
    }

    @Override
    public Page<PCGCategorySellerGoodsDto> findCategoryGoods(long appId, long categoryId, Long consumerId,
                                                             Long consumerCredits, Integer pageIndex, Integer pageSize) {
        List<Long> pcgIds = new ArrayList<Long>();
        // 1.查询标记为黑名单的类目
        List<PCGCategoryEntity> cats = pCGFilterConfigService.findCategoryFilterList(appId);
        List<Long> catIds = new ArrayList<Long>();
        for (PCGCategoryEntity e : cats) {
            catIds.add(e.getId());
        }
        // 2.如果命中，返回空，如果未命中，继续执行
        if (catIds.contains(categoryId)) {
            return new Page<PCGCategorySellerGoodsDto>(pageSize, pageIndex);
        }

        // 3.查询该类目下的所有商品
        List<PCGCategoryGoodsEntity> pCGCategoryGoodsEntity = pCGCategoryGoodsService.findAllGoodsByCategory(categoryId);
        List<PCGIdAndPayLoad> pCGIdAndPayLoads = new ArrayList<PCGIdAndPayLoad>();
        for (PCGCategoryGoodsEntity cateGoods : pCGCategoryGoodsEntity) {
            pcgIds.add(cateGoods.getPcgId());
            pCGIdAndPayLoads.add(new PCGIdAndPayLoad(cateGoods.getPcgId(), cateGoods.getPayload()));
        }

        // 4.商品进行单品黑名单过滤
        pcgIds = filterGoods(pcgIds, appId);
        // 5.放入商品信息
        Page<PCGCategorySellerGoodsDto> page = new Page<PCGCategorySellerGoodsDto>(pageSize, pageIndex);
        if (!pcgIds.isEmpty()) {
            page = findGoods(appId, pcgIds, consumerId, consumerCredits, pCGIdAndPayLoads, pageIndex, pageSize);
        }
        return page;
    }

    /**
     * set排序号
     * 
     * @param pCGCategoryGoodsEntity
     * @param p
     * @return
     */
    public static Integer setPayLoad(List<PCGIdAndPayLoad> ppl, Long pcgId) {
        for (PCGIdAndPayLoad p : ppl) {
            if (p.getPagId().longValue() == pcgId.longValue()) {
                return p.getPayLoad();
            }
        }
        return 0;
    }

    /**
     * 查询商品信息
     * 
     * @param appId
     * @param pcgIds
     * @param consumerId
     * @param consumerCredits
     * @return
     */
    public Page<PCGCategorySellerGoodsDto> findGoods(Long appId, List<Long> pcgIds, Long consumerId,
                                                     Long consumerCredits, List<PCGIdAndPayLoad> pCGIdAndPayLoads,
                                                     Integer pageIndex, Integer pageSize) {
        List<PCGCategorySellerGoodsDto> goodsList = new ArrayList<PCGCategorySellerGoodsDto>();
        /*** 查询开启预分配商品列表 */
        Map<String, GoodsDirectionalConfigEntity> directionals = goodsDirectionalConfigService.findByGoodsAll(GoodsTypeEnum.PLATFORM,
                                                                                                              pcgIds);
        /*** 查询数据库商品列表 */
        Map<Long, PlatformCouponGoodsEntity> pcgs = platformCouponGoodsService.findByIds(pcgIds);
        for (Long pcgIdKey : pcgs.keySet()) {
            GoodsDirectionalConfigEntity gdce1 = null;
            GoodsDirectionalConfigEntity gdce2 = null;
            PlatformCouponGoodsEntity pce = pcgs.get(pcgIdKey);
            // 券是未启用状态,删除状态。返回
            if (PlatformCouponGoodsConstant.PcgStatusOn != pce.getPcgStatus().intValue() || pce.getDeleted()) {
                continue;
            }
            // 开启预分配
            if (isOpen(PlatformCouponGoodsConstant.PcgDirectionalSwitches, pce.getSwitches().intValue())) {
                if (!directionals.isEmpty()) {
                    // 查询是否存在清单
                    gdce1 = directionals.get(appId + "-" + pcgIdKey);
                    // 查询是否存在共享库，共享库appId是0
                    gdce2 = directionals.get(0 + "-" + pcgIdKey);
                    // 如果券开启了库存预分配，且当前应用和共享库均不在预分配清单中则不展示；
                    if (gdce1 == null && gdce2 == null) {
                        continue;
                    }

                }
            }
            PCGCategorySellerGoodsDto psgd = new PCGCategorySellerGoodsDto();
            ObjectUtil.convert(pce, psgd);
            GoodsDirectionalConfigDto gc = new GoodsDirectionalConfigDto();
            // 设置库存
            if (gdce2 != null) {
                ObjectUtil.convert(gdce2, gc);
                if (gdce2.getStockId() == null) {
                    gc.setStock(0L);
                } else {
                    DubboResult<Long> result = remoteStockBackendService.find(gdce2.getStockId());
                    if (result != null && result.isSuccess()) {
                        if (result.getResult() != null ) {
                            gc.setStock(result.getResult());
                        }
                    }
                }
            }
            if (gdce1 != null) {
                gc = new GoodsDirectionalConfigDto();
                ObjectUtil.convert(gdce1, gc);
                if (gdce1.getStockId() == null) {
                    gc.setStock(0L);
                } else {
                    // 当前商品预分配的库存
                    DubboResult<Long> result = remoteStockBackendService.find(gdce1.getStockId());
                    if (result != null && result.isSuccess()) {
                        if (result.getResult() != null ) {
                            gc.setStock(result.getResult());
                        }
                    }
                }
            }
            // 设置开奖预分配对象，积分展示需要调用
            psgd.setGoodsDirectionalConfigDto(gc);
            // 设置排序值
            psgd.setPayLoad(setPayLoad(pCGIdAndPayLoads, psgd.getPcgId()));
            long pcgStock = goodsBatchService.getSumBatchStock(GoodsTypeEnum.PLATFORM, pce.getPcgId());
            psgd.setStock(pcgStock);
            // psgd
            // =checkExchange(psgd,gdce1,gdce2,appId,consumerId,consumerCredits,app.getCreditsRate(),app.getUnitName());
            goodsList.add(psgd);
        }
        return page(pageIndex, pageSize, goodsList);
    }

    @Override
    public Page<PCGCategorySellerGoodsDto> findSellerGoods(long appId, long sellerId, Long consumerId,
                                                           Long consumerCredits, Integer pageIndex, Integer pageSize) {
        List<Long> pcgIds = new ArrayList<Long>();
        List<PCGIdAndPayLoad> pCGIdAndPayLoads = new ArrayList<PCGIdAndPayLoad>();
        // 1.查询标记为黑名单的品牌
        List<PCGSellerEntity> sels = pCGFilterConfigService.findSellerFilterList(appId);
        List<Long> catIds = new ArrayList<Long>();
        for (PCGSellerEntity e : sels) {
            catIds.add(e.getId());
        }
        // 2.如果命中，返回空，如果未命中，继续执行
        if (catIds.contains(sellerId)) {
            return new Page<PCGCategorySellerGoodsDto>(pageSize, pageIndex);
        }

        // 3.查询该类目下的所有商品
        List<PCGSellerGoodsEntity> pCGSellerGoodsEntity = pCGSellerGoodsService.findAllGoodsBySeller(sellerId);
        for (PCGSellerGoodsEntity cateGoods : pCGSellerGoodsEntity) {
            pcgIds.add(cateGoods.getPcgId());
            pCGIdAndPayLoads.add(new PCGIdAndPayLoad(cateGoods.getPcgId(), cateGoods.getPayload()));
        }

        // 4.商品进行单品黑名单过滤
        pcgIds = filterGoods(pcgIds, appId);
        Page<PCGCategorySellerGoodsDto> page = new Page<PCGCategorySellerGoodsDto>(pageSize, pageIndex);
        // 5.放入商品信息
        if (!pcgIds.isEmpty()) {
            page = findGoods(appId, pcgIds, consumerId, consumerCredits, pCGIdAndPayLoads, pageIndex, pageSize);
        }
        return page;
    }

    /**
     * consumerId+pcgId 作为缓存的key
     * 
     * @param pce
     * @param appId
     * @param consumerId 用户id
     * @param consumerIntegral 用户积分
     * @param devRate 开发者汇率
     * @return
     */
    public PCGCategorySellerGoodsDto checkExchange(PCGCategorySellerGoodsDto pce, GoodsDirectionalConfigEntity gdce1,
                                                   GoodsDirectionalConfigEntity gdce2, Long appId, Long consumerId,
                                                   Long consumerIntegral, Integer devRate, String unitName) {
        // 1：已兑换，2：积分不足，3：已兑完，4：兑换
        long pcgStock = goodsBatchService.getSumBatchStock(GoodsTypeEnum.PLATFORM, pce.getPcgId());
        pce.setStock(pcgStock);
        int exchangeType = 0;
        boolean exchangeFlag = true;
        boolean dayLimitFlag = true;// 兑换限额
        // 开启预分配
        Integer minPrice = null;
        Integer count = -1;
        if (pce.getLimitPerConsumer() != null) {
            // 查询用户兑换次数
            count = goodsLimitRecordService.findCount(GoodsTypeEnum.PLATFORM.getGtype(), pce.getPcgId(), consumerId);
        }
        if (gdce2 != null) {
            Long stockId = gdce2.getStockId();
            if (stockId != null) {
                // 当前商品预分配的库存
                DubboResult<Long> result = remoteStockBackendService.find(stockId);
                // 开启了库存预分配，且当前应用不在清单中但共享库在清单中，且共享库的库存为0；
                if (result != null && result.isSuccess()) {
                    if (result.getResult() != null && result.getResult().longValue() == 0) {
                        exchangeFlag = false;
                    }

                }
                if (gdce2.getMinPrice() != null) {
                    minPrice = gdce2.getMinPrice();
                }
                if (gdce2.getDayLimit() != null && (gdce2.getDayLimit() - count) <= 0) {
                    dayLimitFlag = false;
                }
            }
        } else if (gdce1 != null) {
            if (gdce1.getMinPrice() != null) {
                minPrice = gdce1.getMinPrice();
            }
            Long stockId2 = gdce1.getStockId();
            if (stockId2 != null) {
                // 当前商品预分配的库存
                DubboResult<Long> result = remoteStockBackendService.find(stockId2);
                // 开启了库存预分配，且当前应用在清单中，且预分配的库存为0；
                if (result != null && result.isSuccess()) {
                    if (result.getResult() != null && result.getResult().longValue() == 0) {
                        exchangeFlag = false;
                    }

                }
            }
            if (gdce1.getDayLimit() != null && (gdce1.getDayLimit() - count) == 0) {
                dayLimitFlag = false;
            }
        }
        /** 查询数据库中是否存在清单 */
        if (minPrice != null) {
            pce.setMinPrice(minPrice);
        }
        pce.setMinPrice(pce.getMinPrice() * devRate);
        // 已兑换
        if (pce.getLimitPerConsumer() != null && (pce.getLimitPerConsumer() - count) <= 0 || !dayLimitFlag) {// 用户超出兑换限制
            exchangeType = PlatformCouponGoodsConstant.PCGGoodsExchangeType1;
            pce.setPayLoad(pce.getPayLoad() == null ? 0 : pce.getPayLoad() + 400);
            // 积分不足；
        } else if (consumerIntegral <= (pce.getMinPrice())) {// 用户积分 <=兑换价格
            exchangeType = PlatformCouponGoodsConstant.PCGGoodsExchangeType2;
            // 已兑完
        } else if (pce.getStock() == 0 || !exchangeFlag) {
            exchangeType = PlatformCouponGoodsConstant.PCGGoodsExchangeType3;
            pce.setPayLoad(pce.getPayLoad() == null ? 0 : pce.getPayLoad() + 300);
            // 兑换
        } else {
            exchangeType = PlatformCouponGoodsConstant.PCGGoodsExchangeType4;
        }
        pce.setExchangeType(exchangeType);
        List<GoodsBatchDto> goodsBatchs = goodsBatchCouponBackendBO.findBatchs(GoodsTypeEnum.PLATFORM, pce.getPcgId());
        String cuurDate = sdf2.format(new Date());
        for (int i = 0; i < goodsBatchs.size(); i++) {
            // 当前批次发放的券库存大于0 且 必须是有效日期
            if (goodsBatchs.get(i).getStock() > 0
                && Integer.parseInt(sdf2.format(goodsBatchs.get(i).getEndDay())) >= Integer.parseInt(cuurDate)) {
                pce.setStartDate(sdf.format(goodsBatchs.get(i).getStartDay()));
                pce.setEndDate(sdf.format(goodsBatchs.get(i).getEndDay()));
                break;
            }
        }
        // 如果全部批次都已发放完则展示最后添加的那个券码批次的有效期
        if (!goodsBatchs.isEmpty() && StringUtils.isBlank(pce.getEndDate())) {
            pce.setStartDate(sdf.format(goodsBatchs.get(goodsBatchs.size() - 1).getStartDay()));
            pce.setEndDate(sdf.format(goodsBatchs.get(goodsBatchs.size() - 1).getEndDay()));
        }

        pce.setUnitName(unitName);
        return pce;
    }

    public static boolean isOpen(int bit, int switches) {
        int v = 1 << bit;
        int ret = switches & v;
        return ret != 0;
    }

    public <T extends Comparable<? super T>> Page<T> page(Integer pageIndex, Integer pageSize, List<T> t) {
        Page<T> page = new Page<T>(pageSize, pageIndex);
        List<T> newList = new ArrayList<T>();
        page.setList(newList);
        if (t.isEmpty()) {
            return page;
        }
        Collections.sort(t);
        int total = t.size();
        int index = 0;// 循环索引开始
        // 大于两页
        if (pageIndex > 1) {
            index = (pageIndex - 1) * pageSize;
        }
        int totalPages = total % pageSize == 0 ? total / pageSize : (total / pageSize + 1);
        // 索引页必须小于总的页数
        if (pageIndex <= totalPages) {
            if (pageIndex == 1) {
                pageIndex = 0;
            }
            for (int i = index; i < total; i++) {
                // 只取20条，满足跳出
                if (pageSize * (pageIndex + 1) == i) {
                    break;
                }
                newList.add(t.get(i));
            }
        }
        page.setList(newList);
        page.setTotalPages(totalPages);
        page.setPageSize(pageSize);
        page.setCurrent(pageIndex);
        return page;
    }

}
