/**
 * Project Name:goods-center-biz
 * File Name:PCGUtilBO.java
 * Package Name:cn.com.duiba.goods.center.biz.bo.pcg
 * Date:2016年6月28日下午2:14:26
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.bo.pcg;

import cn.com.duiba.goods.center.biz.entity.PlatformCouponGoodsEntity;
import cn.com.duiba.wolf.dubbo.DubboResult;


/**
 * ClassName:PCGUtilBO <br/>
 * Function: 平台券辅助类服务. <br/>
 * Date:     2016年6月28日 下午2:14:26 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface PCGUtilBO {

    public boolean canTakePlatformCouponGoods(long pcgId, long appId, long consumerId) throws Exception;
    
    /**
     * 是否商品在黑名单中，无法进行下单
     * @author xuhengfei
     * @param pcg
     * @return
     * @since JDK 1.6
     */
    public boolean isInBlack(PlatformCouponGoodsEntity pcg,long appId);
    
    public boolean checkStockEnough(long pcgId, long appId, long consumerId);
    /**
     * 计算商品的积分价格
     *
     * @author xuhengfei
     * @param pcgId
     * @param appId
     * @param consumerId
     * @return
     * @since JDK 1.6
     */
    public Long calcultePCGCredits(long pcgId, long appId, long consumerId);
}

