/**
 * Project Name:goods-center-biz
 * File Name:BaseCreditsDao.java
 * Package Name:cn.com.duiba.goods.center.biz.dao
 * Date:2016年6月20日上午11:38:25
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.dao;

import java.util.HashMap;
import java.util.Map;

import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

/**
 * ClassName:BaseCreditsDao <br/>
 * Function: 主库数据库连接 <br/>
 * Date:     2016年6月20日 上午11:38:25 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public class BaseCreditsDao {

    @Autowired
    @Qualifier("creditsSqlSessionTemplate")
    protected SqlSessionTemplate sqlSession;

    protected SqlSessionTemplate getSqlSession() {
        return sqlSession;
    }

    protected String getStamentNameSpace(String method) {
        return getClass().getName() + "." + method;
    }
    
    protected Map<String, Object> getBlankParams(){
        return new HashMap<String, Object>();
    }
}

