/**
 * Project Name:goods-center-biz File Name:AdvertCouponGoodsEntity.java Package
 * Name:cn.com.duiba.goods.center.biz.entity Date:2016年7月13日下午8:35:07 Copyright (c) 2016, duiba.com.cn All Rights
 * Reserved.
 */

package cn.com.duiba.goods.center.biz.entity;

/**
 * ClassName:AdvertCouponGoodsEntity <br/>
 * Function: 广告优惠卷Entity. <br/>
 * Date: 2016年7月13日 下午8:35:07 <br/>
 * 
 * @author Administrator
 * @version
 * @since JDK 1.6
 * @see
 */
public class AdvertCouponGoodsEntity extends BaseEntity {

    /** 优惠卷id. */
    private long    acgId;

    /** 推广网址. */
    private String  promoteURL;

    /** 商品名称. */
    private String  couponName;

    /** 商品价值(单位为分). */
    private Long    couponPrice;

    /** 一句话描述. */
    private String  description;

    /** 品牌图标. */
    private String  thumbnailPng;

    /** 首页banner图. */
    private String  bannerPng;

    /** 领取次数限制. */
    private Integer limitReceive;

    /** 优惠码类型. */
    private Integer codeType;

    /** 是否隐藏. 对特殊应用隐藏使用按钮(0：否，1：是) */
    private boolean specialHide;

    /** 是否为微信券. 是否为微信券(0：否，1：是) (只有code_type=2 or code_type=3时有效) */
    private boolean isWeixin;

    public long getAcgId() {
        return acgId;
    }

    public void setAcgId(long acgId) {
        this.acgId = acgId;
    }

    public String getPromoteURL() {
        return promoteURL;
    }

    public void setPromoteURL(String promoteURL) {
        this.promoteURL = promoteURL;
    }

    public String getCouponName() {
        return couponName;
    }

    public void setCouponName(String couponName) {
        this.couponName = couponName;
    }

    public Long getCouponPrice() {
        return couponPrice;
    }

    public void setCouponPrice(Long couponPrice) {
        this.couponPrice = couponPrice;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getThumbnailPng() {
        return thumbnailPng;
    }

    public void setThumbnailPng(String thumbnailPng) {
        this.thumbnailPng = thumbnailPng;
    }

    public String getBannerPng() {
        return bannerPng;
    }

    public void setBannerPng(String bannerPng) {
        this.bannerPng = bannerPng;
    }

    public Integer getLimitReceive() {
        return limitReceive;
    }

    public void setLimitReceive(Integer limitReceive) {
        this.limitReceive = limitReceive;
    }

    public Integer getCodeType() {
        return codeType;
    }

    public void setCodeType(Integer codeType) {
        this.codeType = codeType;
    }

    public boolean getIsSpecialHide() {
        return specialHide;
    }

    public void setIsSpecialHide(boolean specialHide) {
        this.specialHide = specialHide;
    }

    public boolean getIsWeixin() {
        return isWeixin;
    }

    public void setIsWeixin(boolean isWeixin) {
        this.isWeixin = isWeixin;
    }

}
