/**
 * Project Name:goods-center-biz
 * File Name:RemotePlatformCouponGoodsBackendServiceImpl.java
 * Package Name:cn.com.duiba.goods.center.biz.remoteservice.impl
 * Date:2016年5月19日下午4:03:45
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.remoteservice.impl;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.RemotePlatformCouponGoodsBackendService;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGEditDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGInsertDto;
import cn.com.duiba.goods.center.api.remoteservice.tool.Page;
import cn.com.duiba.goods.center.biz.entity.GoodsContentEntity;
import cn.com.duiba.goods.center.biz.entity.PlatformCouponGoodsEntity;
import cn.com.duiba.goods.center.biz.service.GoodsBatchService;
import cn.com.duiba.goods.center.biz.service.GoodsCenterConfigService;
import cn.com.duiba.goods.center.biz.service.GoodsContentService;
import cn.com.duiba.goods.center.biz.service.PlatformCouponGoodsService;
import cn.com.duiba.goods.center.biz.util.PCGConvertUtil;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemotePlatformCouponGoodsBackendServiceImpl <br/>
 * Date:     2016年5月19日 下午4:03:45 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Service("remotePlatformCouponGoodsBackendService")
public class RemotePlatformCouponGoodsBackendServiceImpl implements RemotePlatformCouponGoodsBackendService{
    private static Logger log=LoggerFactory.getLogger(RemotePlatformCouponGoodsBackendServiceImpl.class);
    @Autowired
    private PlatformCouponGoodsService platformCouponGoodsService;
    @Autowired
    private GoodsContentService goodsContentService;
    @Autowired
    private GoodsBatchService goodsBatchService;
    @Autowired
    private GoodsCenterConfigService goodsCenterConfigService;
    
    @Override
    public DubboResult<Boolean> editHomeImages(String logoImage, String bannerImage) {
        try{
            goodsCenterConfigService.updateHomeImages(logoImage, bannerImage);
            return DubboResult.successResult(true);
        }catch(Exception e){
            log.error("editHomeImages logoImage="+logoImage+",bannerImage="+bannerImage,e);
            return DubboResult.failResult(e.getMessage());
        }
    }
    
    @Override
    public DubboResult<List<String>> getHomeImages() {
        try{
            List<String> ret=goodsCenterConfigService.findHomeImages();
            return DubboResult.successResult(ret);
        }catch(Exception e){
            log.error("getHomeImages ",e);
            return DubboResult.failResult(e.getMessage());
        }
    }
    
    @Override
    public DubboResult<PCGDto> find(long pcgId) {
        try{
            PlatformCouponGoodsEntity e=platformCouponGoodsService.find(pcgId);
            if(e==null){
            	return DubboResult.failResult("商品不存在");
            }
            if(e.getDeleted()){
                return DubboResult.failResult("商品被停用");
            }
            PCGDto dto=PCGConvertUtil.convert(e);
            
            GoodsContentEntity c=goodsContentService.findByGoods(GoodsTypeEnum.PLATFORM, pcgId);
            
            long stock=goodsBatchService.getSumBatchStock(GoodsTypeEnum.PLATFORM, e.getPcgId());
            dto.setStock(stock);
            dto.setTotalStock(goodsBatchService.getTotalAllBatchStock(GoodsTypeEnum.PLATFORM, e.getPcgId()));
            
            
            dto.setDetail(c.getContent());
            return DubboResult.successResult(dto);
        }catch(Exception e){
            log.error("find pcgId="+pcgId,e);
            return DubboResult.failResult(e.getMessage());
        }
    }
    @Override
    public DubboResult<Long> createPlatformCouponGoods(PCGInsertDto goods) {
        try{
            //TODO 修改成事务
            Long pcgId=platformCouponGoodsService.createPlatformCouponGoods(goods);
            if(pcgId!=null){
                goodsContentService.addContent(GoodsTypeEnum.PLATFORM, pcgId, goods.getDetail());
                return DubboResult.successResult(pcgId);
            }else{
                return DubboResult.failResult("创建失败");
            }
        }catch(Exception e){
            log.error("createPlatformCouponGoods error",e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> editPlatformCouponGoods(Long pcgId, PCGEditDto goods) {
        try {
            //TODO 修改成事务
            platformCouponGoodsService.editPlatformCouponGoods(pcgId, goods);
            if(goods.getDetail()!=null){
                goodsContentService.updateContent(GoodsTypeEnum.PLATFORM, pcgId, goods.getDetail());
            }
            return DubboResult.successResult(true);
        } catch (Exception e) {
            log.error("editPlatformCouponGoods error,pcgId="+pcgId,e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> onshelfGoods(Long pcgId) {
        try {
            platformCouponGoodsService.onshelfGoods(pcgId);
            return DubboResult.successResult(true);
        } catch (Exception e) {
            log.error("onshelfGoods error,pcgId="+pcgId,e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> offshelfGoods(Long pcgId) {
        try {
            platformCouponGoodsService.offshelfGoods(pcgId);
            return DubboResult.successResult(true);
        } catch (Exception e) {
            log.error("offshelfGoods error,pcgId="+pcgId,e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> deleteGoods(Long pcgId) {
        try {
            platformCouponGoodsService.deleteGoods(pcgId);
            return DubboResult.successResult(true);
        } catch (Exception e) {
            log.error("deleteGoods error,pcgId="+pcgId,e);
            return DubboResult.failResult(e.getMessage());
        }
    }
    
    @Override
    public DubboResult<List<PCGDto>> searchByName(String name) {
        try{
            List<PlatformCouponGoodsEntity> list=platformCouponGoodsService.searchByName(name);
            List<PCGDto> ret=new ArrayList<>();
            
            for(PlatformCouponGoodsEntity e:list){
                ret.add(PCGConvertUtil.convert(e));
            }
            
            return DubboResult.successResult(ret);
        }catch(Exception e){
            log.error("searchByName name="+name,e);
            return DubboResult.failResult(e.getMessage());
        }
    }
    
    @Override
    public Page<PCGDto> findPage(String name, Integer pcgStatus, int pageSize, int pageIndex) {
        Page<PCGDto> ret=new Page<>(pageSize, pageIndex);
        Page<PlatformCouponGoodsEntity> page= platformCouponGoodsService.findPage(name, pcgStatus, pageSize, pageIndex);
        ret.setTotalCount(page.getTotalCount());
        ret.setTotalPages(page.getTotalPages());
        
        List<PCGDto> pageList=new ArrayList<>();
        for(PlatformCouponGoodsEntity e:page.getList()){
            PCGDto dto=PCGConvertUtil.convert(e);
            long stock=goodsBatchService.getSumBatchStock(GoodsTypeEnum.PLATFORM, e.getPcgId());
            dto.setStock(stock);
            dto.setTotalStock(goodsBatchService.getTotalAllBatchStock(GoodsTypeEnum.PLATFORM, e.getPcgId()));
            pageList.add(dto);
        }
        ret.setList(pageList);
        
        return ret;
    }

    @Override
    public DubboResult<Boolean> editSwitches(Long pcgId,Integer bit,Boolean open) {
        try{
            if(pcgId==null||bit==null||open==null){
                return DubboResult.failResult("参数不得为空！");
            }
            PlatformCouponGoodsEntity entity = this.platformCouponGoodsService.find(pcgId);
            long switches = entity.getSwitches();
            if(open){
                int v = 1<<bit;
                switches = switches | v;
            } else {
                int v = 1 <<bit;
                v = ~v;
                switches = switches & v;
            }
            
            
            this.platformCouponGoodsService.editPCGSwitches(pcgId, switches);
            return DubboResult.successResult(true);
        } catch(Exception e){
            log.error("editSwitches("+pcgId+","+bit+","+open+") invoke error\n",e);
            return DubboResult.failResult(e.getMessage());
        }
        
    }

}

