/**
 * Project Name:goods-center-biz
 * File Name:RemotePCGGoodsInfoServiceImpl.java
 * Package Name:cn.com.duiba.goods.center.biz.remoteservice.pcg
 * Date:2016年6月29日下午9:40:12
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.remoteservice.pcg;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGCategoryDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGCategorySellerGoodsDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGSellerDto;
import cn.com.duiba.goods.center.api.remoteservice.front.RemotePCGGoodsInfoService;
import cn.com.duiba.goods.center.api.remoteservice.tool.Page;
import cn.com.duiba.goods.center.biz.bo.PCGFilterConfigBO;
import cn.com.duiba.goods.center.biz.entity.GoodsContentEntity;
import cn.com.duiba.goods.center.biz.entity.PCGCategoryEntity;
import cn.com.duiba.goods.center.biz.entity.PCGSellerEntity;
import cn.com.duiba.goods.center.biz.entity.PlatformCouponGoodsEntity;
import cn.com.duiba.goods.center.biz.service.GoodsContentService;
import cn.com.duiba.goods.center.biz.service.PCGCategoryGoodsService;
import cn.com.duiba.goods.center.biz.service.PCGFilterConfigService;
import cn.com.duiba.goods.center.biz.service.PCGSellerGoodsService;
import cn.com.duiba.goods.center.biz.service.PlatformCouponGoodsService;
import cn.com.duiba.goods.center.biz.util.PCGConvertUtil;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.ObjectUtil;

/**
 * ClassName:RemotePCGGoodsInfoServiceImpl <br/>
 * Date:     2016年6月29日 下午9:40:12 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see      
 */
@Service("remotePCGGoodsInfoService")
public class RemotePCGGoodsInfoServiceImpl implements RemotePCGGoodsInfoService{
    /**日志Logger*/
    private static Logger LOGER=LoggerFactory.getLogger(RemotePCGGoodsInfoServiceImpl.class);
    @Autowired
    private PlatformCouponGoodsService platformCouponGoodsService;
    @Autowired
    private PCGFilterConfigService pCGFilterConfigService;
    @Autowired
    private PCGSellerGoodsService pCGSellerGoodsService;
    @Autowired
    private PCGCategoryGoodsService pCGCategoryGoodsService;
    @Autowired
    private PCGFilterConfigBO pCGFilterConfigBO;
    @Autowired
    private GoodsContentService           goodsContentService;
    @Override
    public PCGDto find(long pcgId) {
        PlatformCouponGoodsEntity pcg= platformCouponGoodsService.find(pcgId);
        if(pcg==null){
            return null;
        }
        PCGDto dto=PCGConvertUtil.convert(pcg);
        return dto;
    }
    
    @Override
    public PCGDto findIncludeDeleted(long pcgId) {
        PlatformCouponGoodsEntity pcg= platformCouponGoodsService.findIncludeDeleted(pcgId);
        if(pcg==null){
            return null;
        }
        PCGDto dto=PCGConvertUtil.convert(pcg);
        // 查询平台券信息
        GoodsContentEntity goods = goodsContentService.findByGoods(GoodsTypeEnum.PLATFORM, pcgId);
        if(goods !=null ){
            dto.setDetail(goods.getContent());
        }
        return dto;
    }
    @Override
    public DubboResult<List<PCGCategoryDto>> findCategoryAll() {
        try{
            List<PCGCategoryDto>  PCGCategoryDtos = new ArrayList<PCGCategoryDto>();
            List<PCGCategoryEntity> categorys =  pCGCategoryGoodsService.findAll();
            ObjectUtil.convertList(categorys, PCGCategoryDtos, PCGCategoryDto.class);
            return DubboResult.successResult(PCGCategoryDtos);
        } catch (Exception e) {
            LOGER.error("findCategoryAll",e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<List<PCGSellerDto>> findSellerAll() {
        try{
            List<PCGSellerDto> pCGSellerDtos = new ArrayList<PCGSellerDto>();
            List<PCGSellerEntity> sellers= pCGSellerGoodsService.findAll();
            ObjectUtil.convertList(sellers, pCGSellerDtos, PCGSellerDto.class);
            return DubboResult.successResult(pCGSellerDtos);
        } catch (Exception e) {
            LOGER.error("findSellerAll",e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Page<PCGCategorySellerGoodsDto>> findCategoryGoods(long appId,long categoryId,Long consumerId,Long consumerCredits, Integer pageIndex, Integer pageSize) {
        try{
            Page<PCGCategorySellerGoodsDto> page = pCGFilterConfigBO.findCategoryGoods(appId,categoryId, consumerId, consumerCredits,  pageIndex, pageSize);
            return DubboResult.successResult(page);
        } catch (Exception e) {
            LOGER.error("findCategoryGoods appId="+appId+",consumerId="+consumerId+",consumerCredits="+consumerCredits+",pageIndex="+pageIndex+",pageSize="+pageSize,e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Page<PCGCategorySellerGoodsDto>> findSellerGoods(long appId,long sellerId,Long consumerId,Long consumerCredits, Integer pageIndex, Integer pageSize) {
        try{
            Page<PCGCategorySellerGoodsDto> page = pCGFilterConfigBO.findSellerGoods(appId,sellerId, consumerId, consumerCredits, pageIndex, pageSize);
            return DubboResult.successResult(page);
        } catch (Exception e) {
            LOGER.error("findSellerGoods appId="+appId+",consumerId="+consumerId+",consumerCredits="+consumerCredits+",pageIndex="+pageIndex+",pageSize="+pageSize,e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<List<Long>> findPCGFilterTargetIds(Long appId,Integer type) {
        try{
            List<Long> list = pCGFilterConfigService.selectPCGFilterTargetIds(appId, type);
            return DubboResult.successResult(list);
        }catch(Exception e){
            LOGER.error("findPCGFilterTargetIds appId="+appId+",type="+type,e);
            return DubboResult.failResult(e.getMessage());
        }
    }
    @Override
    public DubboResult<PCGCategorySellerGoodsDto> findSellerGoodsInfo(long appId, long gid, Long consumerId, Long consumerCredits) {
        try{
            PCGCategorySellerGoodsDto dto = pCGFilterConfigService.findSellerGoodsInfo(appId,gid,consumerId,consumerCredits);
            return DubboResult.successResult(dto);
        }catch(Exception e){
            LOGER.error("findGoodsCouponInfo gid="+gid,e);
            return DubboResult.failResult(e.getMessage());
        }
    }

}

